/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import ic2.api.Direction;
import ic2.api.IEnergyAcceptor;
import ic2.api.IEnergyConductor;
import ic2.api.IEnergyEmitter;
import ic2.api.IEnergySink;
import ic2.api.IEnergySource;
import ic2.api.IEnergyTile;
import ic2.common.IC2DamageSource;
import ic2.platform.Platform;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public final class EnergyNet {
    public static final double minConductionLoss = 1.0E-4;
    private static Map worldToEnergyNetMap = new HashMap();
    private xd world;
    private Map energySourceToEnergyPathMap = new HashMap();
    private Map entityLivingToShockEnergyMap = new HashMap();

    public static EnergyNet getForWorld(xd world) {
        if (world == null) {
            System.out.println("[IC2] EnergyNet.getForWorld: world = null, bad things may happen..");
            return null;
        }
        if (!worldToEnergyNetMap.containsKey(world)) {
            worldToEnergyNetMap.put(world, new EnergyNet(world));
        }
        return (EnergyNet)worldToEnergyNetMap.get(world);
    }

    public static void onTick(xd world) {
        Platform.profilerStartSection("Shocking");
        EnergyNet energyNet = EnergyNet.getForWorld(world);
        for (Map.Entry entry : energyNet.entityLivingToShockEnergyMap.entrySet()) {
            acq target = (acq)entry.getKey();
            int damage = ((Integer)entry.getValue() + 63) / 64;
            if (!target.M()) continue;
            target.a((md)IC2DamageSource.electricity, damage);
        }
        energyNet.entityLivingToShockEnergyMap.clear();
        Platform.profilerEndSection();
    }

    private EnergyNet(xd world) {
        this.world = world;
    }

    public void addTileEntity(kw addedTileEntity) {
        if (!(addedTileEntity instanceof IEnergyTile) || ((IEnergyTile)addedTileEntity).isAddedToEnergyNet()) {
            boolean alreadyAdded = addedTileEntity instanceof IEnergyTile ? ((IEnergyTile)addedTileEntity).isAddedToEnergyNet() : false;
            System.out.println("[IC2] adding " + addedTileEntity + " to the EnergyNet failed, already added: " + alreadyAdded);
            Thread.dumpStack();
            return;
        }
        if (addedTileEntity instanceof IEnergyAcceptor) {
            List reverseEnergyPaths = this.discover(addedTileEntity, true, Integer.MAX_VALUE);
            for (EnergyPath reverseEnergyPath : reverseEnergyPaths) {
                IEnergySource energySource = (IEnergySource)reverseEnergyPath.target;
                if (!this.energySourceToEnergyPathMap.containsKey(energySource) || (double)energySource.getMaxEnergyOutput() <= reverseEnergyPath.loss) continue;
                this.energySourceToEnergyPathMap.remove(energySource);
            }
        }
        if (addedTileEntity instanceof IEnergySource) {
            // empty if block
        }
    }

    public void removeTileEntity(kw removedTileEntity) {
        if (!(removedTileEntity instanceof IEnergyTile) || !((IEnergyTile)removedTileEntity).isAddedToEnergyNet()) {
            boolean alreadyRemoved = removedTileEntity instanceof IEnergyTile ? !((IEnergyTile)removedTileEntity).isAddedToEnergyNet() : true;
            System.out.println("[IC2] removing " + removedTileEntity + " from the EnergyNet failed, already removed: " + alreadyRemoved);
            Thread.dumpStack();
            return;
        }
        if (removedTileEntity instanceof IEnergyAcceptor) {
            List reverseEnergyPaths = this.discover(removedTileEntity, true, Integer.MAX_VALUE);
            block0: for (EnergyPath reverseEnergyPath : reverseEnergyPaths) {
                IEnergySource energySource = (IEnergySource)reverseEnergyPath.target;
                if (!this.energySourceToEnergyPathMap.containsKey(energySource) || (double)energySource.getMaxEnergyOutput() <= reverseEnergyPath.loss) continue;
                if (removedTileEntity instanceof IEnergyConductor) {
                    this.energySourceToEnergyPathMap.remove(energySource);
                    continue;
                }
                Iterator it = ((List)this.energySourceToEnergyPathMap.get(energySource)).iterator();
                while (it.hasNext()) {
                    if (((EnergyPath)it.next()).target != removedTileEntity) continue;
                    it.remove();
                    continue block0;
                }
            }
        }
        if (removedTileEntity instanceof IEnergySource) {
            this.energySourceToEnergyPathMap.remove((IEnergySource)removedTileEntity);
        }
    }

    public int emitEnergyFrom(IEnergySource energySource, int amount) {
        IEnergySink energySink;
        if (!energySource.isAddedToEnergyNet()) {
            System.out.println("[IC2] EnergyNet.emitEnergyFrom: " + energySource + " is not added to the enet");
            return amount;
        }
        if (!this.energySourceToEnergyPathMap.containsKey(energySource)) {
            this.energySourceToEnergyPathMap.put(energySource, this.discover((kw)energySource, false, energySource.getMaxEnergyOutput()));
        }
        int energyConsumed = 0;
        Vector<EnergyPath> activeEnergyPaths = new Vector<EnergyPath>();
        double totalInvLoss = 0.0;
        for (EnergyPath energyPath : (List)this.energySourceToEnergyPathMap.get(energySource)) {
            assert (energyPath.target instanceof IEnergySink);
            energySink = (IEnergySink)energyPath.target;
            if (!energySink.demandsEnergy()) continue;
            totalInvLoss += 1.0 / energyPath.loss;
            activeEnergyPaths.add(energyPath);
            if (activeEnergyPaths.size() < amount) continue;
            break;
        }
        for (EnergyPath energyPath : activeEnergyPaths) {
            int energyLoss;
            energySink = (IEnergySink)energyPath.target;
            int energyProvided = (int)Math.floor((double)Math.round((double)amount / totalInvLoss / energyPath.loss * 100000.0) / 100000.0);
            if (energyProvided <= (energyLoss = (int)Math.floor(energyPath.loss))) continue;
            int energyReturned = energySink.injectEnergy(energyPath.targetDirection, energyProvided - energyLoss);
            energyConsumed += energyProvided - energyReturned;
            int energyInjected = energyProvided - energyLoss - energyReturned;
            energyPath.totalEnergyConducted += (long)energyInjected;
            if (energyInjected > energyPath.minInsulationEnergyAbsorption) {
                List entitiesNearEnergyPath = this.world.a(acq.class, wu.a((double)(energyPath.minX - 1), (double)(energyPath.minY - 1), (double)(energyPath.minZ - 1), (double)(energyPath.maxX + 2), (double)(energyPath.maxY + 2), (double)(energyPath.maxZ + 2)));
                for (acq entityLiving : entitiesNearEnergyPath) {
                    int maxShockEnergy = 0;
                    for (IEnergyConductor energyConductor : energyPath.conductors) {
                        kw te = (kw)energyConductor;
                        if (!entityLiving.y.a(wu.a((double)(te.j - 1), (double)(te.k - 1), (double)(te.l - 1), (double)(te.j + 2), (double)(te.k + 2), (double)(te.l + 2)))) continue;
                        int shockEnergy = energyInjected - energyConductor.getInsulationEnergyAbsorption();
                        if (shockEnergy > maxShockEnergy) {
                            maxShockEnergy = shockEnergy;
                        }
                        if (energyConductor.getInsulationEnergyAbsorption() != energyPath.minInsulationEnergyAbsorption) continue;
                        break;
                    }
                    if (this.entityLivingToShockEnergyMap.containsKey(entityLiving)) {
                        this.entityLivingToShockEnergyMap.put(entityLiving, (Integer)this.entityLivingToShockEnergyMap.get(entityLiving) + maxShockEnergy);
                        continue;
                    }
                    this.entityLivingToShockEnergyMap.put(entityLiving, maxShockEnergy);
                }
                if (energyInjected >= energyPath.minInsulationBreakdownEnergy) {
                    for (IEnergyConductor energyConductor : energyPath.conductors) {
                        if (energyInjected < energyConductor.getInsulationBreakdownEnergy()) continue;
                        energyConductor.removeInsulation();
                        if (energyConductor.getInsulationEnergyAbsorption() >= energyPath.minInsulationEnergyAbsorption) continue;
                        energyPath.minInsulationEnergyAbsorption = energyConductor.getInsulationEnergyAbsorption();
                    }
                }
            }
            if (energyInjected < energyPath.minConductorBreakdownEnergy) continue;
            for (IEnergyConductor energyConductor : energyPath.conductors) {
                if (energyInjected < energyConductor.getConductorBreakdownEnergy()) continue;
                energyConductor.removeConductor();
            }
        }
        return amount - energyConsumed;
    }

    public long getTotalEnergyConducted(kw tileEntity) {
        long ret = 0L;
        if (tileEntity instanceof IEnergyConductor || tileEntity instanceof IEnergySink) {
            List reverseEnergyPaths = this.discover(tileEntity, true, Integer.MAX_VALUE);
            for (EnergyPath reverseEnergyPath : reverseEnergyPaths) {
                IEnergySource energySource = (IEnergySource)reverseEnergyPath.target;
                if (!this.energySourceToEnergyPathMap.containsKey(energySource) || (double)energySource.getMaxEnergyOutput() <= reverseEnergyPath.loss) continue;
                for (EnergyPath energyPath : (List)this.energySourceToEnergyPathMap.get(energySource)) {
                    if ((!(tileEntity instanceof IEnergySink) || energyPath.target != tileEntity) && (!(tileEntity instanceof IEnergyConductor) || !energyPath.conductors.contains((IEnergyConductor)tileEntity))) continue;
                    ret += energyPath.totalEnergyConducted;
                }
            }
        }
        if (tileEntity instanceof IEnergySource && this.energySourceToEnergyPathMap.containsKey((IEnergySource)tileEntity)) {
            for (EnergyPath energyPath : (List)this.energySourceToEnergyPathMap.get((IEnergySource)tileEntity)) {
                ret += energyPath.totalEnergyConducted;
            }
        }
        return ret;
    }

    private List discover(kw emitter, boolean reverse, int lossLimit) {
        HashMap<kw, EnergyBlockLink> reachedTileEntities = new HashMap<kw, EnergyBlockLink>();
        LinkedList<kw> tileEntitiesToCheck = new LinkedList<kw>();
        tileEntitiesToCheck.add(emitter);
        while (!tileEntitiesToCheck.isEmpty()) {
            kw currentTileEntity = (kw)tileEntitiesToCheck.remove();
            if (currentTileEntity.l()) continue;
            double currentLoss = 0.0;
            if (currentTileEntity != emitter) {
                currentLoss = ((EnergyBlockLink)reachedTileEntities.get((Object)currentTileEntity)).loss;
            }
            List validReceivers = this.getValidReceivers(currentTileEntity, reverse);
            for (EnergyTarget validReceiver : validReceivers) {
                if (validReceiver.tileEntity == emitter) continue;
                double additionalLoss = 0.0;
                if (validReceiver.tileEntity instanceof IEnergyConductor) {
                    additionalLoss = ((IEnergyConductor)validReceiver.tileEntity).getConductionLoss();
                    if (additionalLoss < 1.0E-4) {
                        additionalLoss = 1.0E-4;
                    }
                    if (currentLoss + additionalLoss >= (double)lossLimit) continue;
                }
                if (reachedTileEntities.containsKey(validReceiver.tileEntity) && !(((EnergyBlockLink)reachedTileEntities.get((Object)validReceiver.tileEntity)).loss > currentLoss + additionalLoss)) continue;
                reachedTileEntities.put(validReceiver.tileEntity, new EnergyBlockLink(validReceiver.direction, currentLoss + additionalLoss));
                if (!(validReceiver.tileEntity instanceof IEnergyConductor)) continue;
                tileEntitiesToCheck.remove(validReceiver.tileEntity);
                tileEntitiesToCheck.add(validReceiver.tileEntity);
            }
        }
        LinkedList<EnergyPath> energyPaths = new LinkedList<EnergyPath>();
        block2: for (Map.Entry entry : reachedTileEntities.entrySet()) {
            kw tileEntity = (kw)entry.getKey();
            if ((reverse || !(tileEntity instanceof IEnergySink)) && (!reverse || !(tileEntity instanceof IEnergySource))) continue;
            EnergyBlockLink energyBlockLink = (EnergyBlockLink)entry.getValue();
            EnergyPath energyPath = new EnergyPath();
            energyPath.loss = energyBlockLink.loss > 0.1 ? energyBlockLink.loss : 0.1;
            energyPath.target = tileEntity;
            energyPath.targetDirection = energyBlockLink.direction;
            if (!reverse && emitter instanceof IEnergySource) {
                while ((tileEntity = energyBlockLink.direction.applyToTileEntity(tileEntity)) != emitter) {
                    if (tileEntity instanceof IEnergyConductor) {
                        IEnergyConductor energyConductor = (IEnergyConductor)tileEntity;
                        if (tileEntity.j < energyPath.minX) {
                            energyPath.minX = tileEntity.j;
                        }
                        if (tileEntity.k < energyPath.minY) {
                            energyPath.minY = tileEntity.k;
                        }
                        if (tileEntity.l < energyPath.minZ) {
                            energyPath.minZ = tileEntity.l;
                        }
                        if (tileEntity.j > energyPath.maxX) {
                            energyPath.maxX = tileEntity.j;
                        }
                        if (tileEntity.k > energyPath.maxY) {
                            energyPath.maxY = tileEntity.k;
                        }
                        if (tileEntity.l > energyPath.maxZ) {
                            energyPath.maxZ = tileEntity.l;
                        }
                        energyPath.conductors.add(energyConductor);
                        if (energyConductor.getInsulationEnergyAbsorption() < energyPath.minInsulationEnergyAbsorption) {
                            energyPath.minInsulationEnergyAbsorption = energyConductor.getInsulationEnergyAbsorption();
                        }
                        if (energyConductor.getInsulationBreakdownEnergy() < energyPath.minInsulationBreakdownEnergy) {
                            energyPath.minInsulationBreakdownEnergy = energyConductor.getInsulationBreakdownEnergy();
                        }
                        if (energyConductor.getConductorBreakdownEnergy() < energyPath.minConductorBreakdownEnergy) {
                            energyPath.minConductorBreakdownEnergy = energyConductor.getConductorBreakdownEnergy();
                        }
                        if ((energyBlockLink = (EnergyBlockLink)reachedTileEntities.get(tileEntity)) != null) continue;
                        Platform.displayError("An energy network pathfinding entry is corrupted.\nThis could happen due to incorrect Minecraft behavior or a bug.\n\n(Technical information: energyBlockLink, tile entities below)\nE: " + emitter + " (" + emitter.j + "," + emitter.k + "," + emitter.l + ")\n" + "C: " + tileEntity + " (" + tileEntity.j + "," + tileEntity.k + "," + tileEntity.l + ")\n" + "R: " + energyPath.target + " (" + energyPath.target.j + "," + energyPath.target.k + "," + energyPath.target.l + ")");
                        continue;
                    }
                    if (tileEntity == null) continue block2;
                    System.out.println("EnergyNet: EnergyBlockLink corrupted (" + energyPath.target + " [" + energyPath.target.j + " " + energyPath.target.k + " " + energyPath.target.l + "] -> " + tileEntity + " [" + tileEntity.j + " " + tileEntity.k + " " + tileEntity.l + "] -> " + emitter + " [" + emitter.j + " " + emitter.k + " " + emitter.l + "])");
                    continue block2;
                }
            }
            energyPaths.add(energyPath);
        }
        return energyPaths;
    }

    private List getValidReceivers(kw emitter, boolean reverse) {
        LinkedList<EnergyTarget> validReceivers = new LinkedList<EnergyTarget>();
        for (Direction direction : Direction.values()) {
            kw target = direction.applyToTileEntity(emitter);
            if (!(target instanceof IEnergyTile) || !((IEnergyTile)target).isAddedToEnergyNet()) continue;
            Direction inverseDirection = direction.getInverse();
            if ((reverse || !(emitter instanceof IEnergyEmitter) || !((IEnergyEmitter)emitter).emitsEnergyTo(target, direction)) && (!reverse || !(emitter instanceof IEnergyAcceptor) || !((IEnergyAcceptor)emitter).acceptsEnergyFrom(target, direction)) || (reverse || !(target instanceof IEnergyAcceptor) || !((IEnergyAcceptor)target).acceptsEnergyFrom(emitter, inverseDirection)) && (!reverse || !(target instanceof IEnergyEmitter) || !((IEnergyEmitter)target).emitsEnergyTo(emitter, inverseDirection))) continue;
            validReceivers.add(new EnergyTarget(target, inverseDirection));
        }
        return validReceivers;
    }

    static class EnergyTarget {
        kw tileEntity;
        Direction direction;

        EnergyTarget(kw tileEntity, Direction direction) {
            this.tileEntity = tileEntity;
            this.direction = direction;
        }
    }

    static class EnergyBlockLink {
        Direction direction;
        double loss;

        EnergyBlockLink(Direction direction, double loss) {
            this.direction = direction;
            this.loss = loss;
        }
    }

    static class EnergyPath {
        kw target = null;
        Direction targetDirection;
        Set conductors = new HashSet();
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        double loss = 0.0;
        int minInsulationEnergyAbsorption = Integer.MAX_VALUE;
        int minInsulationBreakdownEnergy = Integer.MAX_VALUE;
        int minConductorBreakdownEnergy = Integer.MAX_VALUE;
        long totalEnergyConducted = 0L;

        EnergyPath() {
        }
    }
}

