/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import forge.ISidedInventory;
import ic2.common.ContainerBaseGenerator;
import ic2.common.ContainerIC2;
import ic2.common.Ic2Items;
import ic2.common.TileEntityBaseGenerator;
import ic2.platform.Platform;

public class TileEntityGeoGenerator
extends TileEntityBaseGenerator
implements ISidedInventory {
    public int maxLava = 24000;

    public TileEntityGeoGenerator() {
        super(2, mod_IC2.energyGeneratorGeo, mod_IC2.energyGeneratorGeo);
    }

    @Override
    public int gaugeFuelScaled(int i) {
        if (this.fuel <= 0) {
            return 0;
        }
        return this.fuel * i / this.maxLava;
    }

    @Override
    public boolean gainFuel() {
        if (this.inventory[1] == null || this.maxLava - this.fuel < 1000) {
            return false;
        }
        if (this.inventory[1].c == yr.ay.bQ) {
            this.fuel += 1000;
            this.inventory[1].c = yr.aw.bQ;
            return true;
        }
        if (this.inventory[1].c == Ic2Items.lavaCell.c) {
            this.fuel += 1000;
            --this.inventory[1].a;
            if (this.inventory[1].a <= 0) {
                this.inventory[1] = null;
            }
            return true;
        }
        if (this.gainFuelSub(this.inventory[1])) {
            this.fuel += 1000;
            if (this.inventory[1].a().m()) {
                this.inventory[1] = new aan(this.inventory[1].a().l());
            } else {
                --this.inventory[1].a;
                if (this.inventory[1].a <= 0) {
                    this.inventory[1] = null;
                }
            }
            return true;
        }
        return false;
    }

    public boolean gainFuelSub(aan stack) {
        return false;
    }

    @Override
    public boolean needsFuel() {
        return this.fuel <= this.maxLava;
    }

    public int distributeLava(int amount) {
        int need = this.maxLava - this.fuel;
        if (need > amount) {
            need = amount;
        }
        this.fuel += need / 2;
        return amount -= need;
    }

    @Override
    public String c() {
        if (Platform.isRendering()) {
            return "Geothermal Generator";
        }
        return "Geoth. Generator";
    }

    @Override
    public String getOperationSoundFile() {
        return "Generators/GeothermalLoop.ogg";
    }

    @Override
    public ContainerIC2 getGuiContainer(yw entityPlayer) {
        return new ContainerBaseGenerator(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(yw entityPlayer) {
        return "GuiGeoGenerator";
    }

    public int getStartInventorySide(int side) {
        switch (side) {
            case 0: {
                return 1;
            }
        }
        return 0;
    }

    public int getSizeInventorySide(int side) {
        return 1;
    }
}

