package net.minecraft.src.ic2.advancedmachines;

import net.minecraft.src.*;
import net.minecraft.src.forge.*;
import net.minecraft.src.ic2.api.*;

import java.util.*;

public class BlockAdvancedMachines extends BlockContainer implements ITextureProvider
{
    public BlockAdvancedMachines(int var1)
    {
        super(var1, Material.iron);
        this.setHardness(2.0F);
        this.setStepSound(soundMetalFootstep);
    }

    public TileEntity getBlockEntity()
    {
        return null;
    }

    public void onBlockAdded(World var1, int var2, int var3, int var4)
    {
        TileEntityAdvancedMachine var5 = this.getBlockEntity(var1.getBlockMetadata(var2, var3, var4));
        var1.setBlockTileEntity(var2, var3, var4, var5);
    }

    public ArrayList getBlockDropped(World var1, int var2, int var3, int var4, int var5, int var6)
    {
        ArrayList var7 = super.getBlockDropped(var1, var2, var3, var4, var5, var6);
        TileEntity var8 = var1.getBlockTileEntity(var2, var3, var4);
        if (var8 instanceof IInventory)
        {
            IInventory var9 = (IInventory)var8;

            for (int var10 = 0; var10 < var9.getSizeInventory(); ++var10)
            {
                ItemStack var11 = var9.getStackInSlot(var10);
                if (var11 != null)
                {
                    var7.add(var11);
                    var9.setInventorySlotContents(var10, (ItemStack)null);
                }
            }
        }

        return var7;
    }

    public void onBlockRemoval(World var1, int var2, int var3, int var4)
    {
        boolean var5 = true;

        for (Iterator var6 = this.getBlockDropped(var1, var2, var3, var4, var1.getBlockMetadata(var2, var3, var4), 0).iterator(); var6.hasNext(); var5 = false)
        {
            ItemStack var7 = (ItemStack)var6.next();
            if (!var5)
            {
                if (var7 == null)
                {
                    return;
                }

                double var8 = 0.7D;
                double var10 = (double)var1.rand.nextFloat() * var8 + (1.0D - var8) * 0.5D;
                double var12 = (double)var1.rand.nextFloat() * var8 + (1.0D - var8) * 0.5D;
                double var14 = (double)var1.rand.nextFloat() * var8 + (1.0D - var8) * 0.5D;
                EntityItem var16 = new EntityItem(var1, (double)var2 + var10, (double)var3 + var12, (double)var4 + var14, var7);
                var16.delayBeforeCanPickup = 10;
                var1.spawnEntityInWorld(var16);
                return;
            }
        }
    }

    public int idDropped(int var1, Random var2, int var3)
    {
        return Items.getItem("advancedMachine").itemID;
    }

    protected int damageDropped(int var1)
    {
        return 12;
    }

    public Integer getGui(World var1, int var2, int var3, int var4, EntityPlayer var5)
    {
        switch (var1.getBlockMetadata(var2, var3, var4))
        {
            case 0:
                return Integer.valueOf(mod_IC2AdvancedMachines.guiIdRotary);
            case 1:
                return Integer.valueOf(mod_IC2AdvancedMachines.guiIdSingularity);
            case 2:
                return Integer.valueOf(mod_IC2AdvancedMachines.guiIdCentrifuge);
            default:
                return null;
        }
    }

    public TileEntityAdvancedMachine getBlockEntity(int var1)
    {
        switch (var1)
        {
            case 0:
                return new TileEntityRotaryMacerator();
            case 1:
                return new TileEntitySingularityCompressor();
            case 2:
                return new TileEntityCentrifugeExtractor();
            default:
                return null;
        }
    }

    public void onBlockPlacedBy(World var1, int var2, int var3, int var4, EntityLiving var5)
    {
        int var6 = MathHelper.floor_double((double)(var5.rotationYaw * 4.0F / 360.0F) + 0.5D) & 3;
        TileEntityAdvancedMachine var7 = (TileEntityAdvancedMachine)var1.getBlockTileEntity(var2, var3, var4);
        switch (var6)
        {
            case 0:
                var7.setFacing((short)2);
                break;
            case 1:
                var7.setFacing((short)5);
                break;
            case 2:
                var7.setFacing((short)3);
                break;
            case 3:
                var7.setFacing((short)4);
        }
    }

    public boolean blockActivated(World var1, int var2, int var3, int var4, EntityPlayer var5)
    {
        if (var5.isSneaking())
        {
            return false;
        }
        else
        {
        	var5.openGui(mod_IC2AdvancedMachines.instance, 0, var1, var2, var3, var4);
        	return true;
        	/*
            Integer var6 = this.getGui(var1, var2, var3, var4, var5);
            if (var6 == null)
            {
                return false;
            }
            else
            {
                mod_IC2AdvancedMachines.showGui(var5, var6.intValue(), var1.getBlockTileEntity(var2, var3, var4));
                return true;
            }
            */
        }
    }

    public static boolean isActive(IBlockAccess var0, int var1, int var2, int var3)
    {
        return ((TileEntityAdvancedMachine)var0.getBlockTileEntity(var1, var2, var3)).getActive();
    }

    public static int getFacing(IBlockAccess var0, int var1, int var2, int var3)
    {
        return ((TileEntityAdvancedMachine)var0.getBlockTileEntity(var1, var2, var3)).getFacing();
    }

    public static float getWrenchRate(IBlockAccess var0, int var1, int var2, int var3)
    {
        return ((TileEntityAdvancedMachine)var0.getBlockTileEntity(var1, var2, var3)).getWrenchDropRate();
    }

    public void randomDisplayTick(World var1, int var2, int var3, int var4, Random var5)
    {
        int var6 = var1.getBlockMetadata(var2, var3, var4);
        if (var6 == 0 && isActive(var1, var2, var3, var4))
        {
            float var7 = (float)var2 + 1.0F;
            float var8 = (float)var3 + 1.0F;
            float var9 = (float)var4 + 1.0F;

            for (int var10 = 0; var10 < 4; ++var10)
            {
                float var11 = -0.2F - var5.nextFloat() * 0.6F;
                float var12 = -0.1F + var5.nextFloat() * 0.2F;
                float var13 = -0.2F - var5.nextFloat() * 0.6F;
                var1.spawnParticle("smoke", (double)(var7 + var11), (double)(var8 + var12), (double)(var9 + var13), 0.0D, 0.0D, 0.0D);
            }
        }
    }

	@Override
	public String getTextureFile()
	{
		return null;
	}
}
