package net.minecraft.src.ic2.advancedmachines;

import java.util.*;
import net.minecraft.src.*;
import net.minecraft.src.forge.*;
import net.minecraft.src.ic2.api.*;

public class TileEntitySingularityCompressor extends TileEntityAdvancedMachine
{
    public TileEntitySingularityCompressor()
    {
        super("Singularity Compressor", "%6d PSI", 10, new int[] {0}, new int[] {2});
    }

    public Container getGuiContainer(InventoryPlayer var1)
    {
        return new ContainerSingularityCompressor(var1, this);
    }

    protected List getResultMap()
    {
        return Ic2Recipes.getCompressorRecipes();
    }

    public ItemStack getResultFor(ItemStack var1, boolean var2)
    {
        return Ic2Recipes.getCompressorOutputFor(var1, var2);
    }
}
