package net.minecraft.src;

import java.io.*;

import net.minecraft.client.Minecraft;
import net.minecraft.src.forge.*;
import net.minecraft.src.powercrystals.powerconverters.*;

public class mod_PowerConverters extends NetworkMod implements IConnectionHandler, IPacketHandler
{
	public void load()
	{
		PowerConverterCore.init(new ClientProxy());
		
		MinecraftForge.registerConnectionHandler(this);
		
		ModLoader.addName(new ItemStack(PowerConverterCore.powerConverterBlock, 1, 0), "Engine Generator (LV)");
		ModLoader.addName(new ItemStack(PowerConverterCore.powerConverterBlock, 1, 1), "Engine Generator (MV)");
		ModLoader.addName(new ItemStack(PowerConverterCore.powerConverterBlock, 1, 2), "Engine Generator (HV)");
		ModLoader.addName(new ItemStack(PowerConverterCore.powerConverterBlock, 1, 3), "Oil Fabricator");
		ModLoader.addName(new ItemStack(PowerConverterCore.powerConverterBlock, 1, 4), "Energy Link");
		ModLoader.addName(new ItemStack(PowerConverterCore.powerConverterBlock, 1, 5), "Lava Fabricator");
		ModLoader.addName(new ItemStack(PowerConverterCore.powerConverterBlock, 1, 6), "Geothermal Generator Mk. 2");
		ModLoader.addName(new ItemStack(PowerConverterCore.powerConverterBlock, 1, 7), "Water Strainer");
		
		ModLoader.addName(PowerConverterCore.jetpackFuellerItem, "Jetpack Fueller");
	}
	
	@Override
	public String getVersion()
	{
		return PowerConverterCore.version;
	}
	
	/** This is to force Power Converters to load after the required mods, IC2 and BC2 + BC2 Energy.
	  * Unfortunately this doesn't work with server-side MLMP.
	  */
	@Override
	public String getPriorities()
	{
		return "after:mod_BuildCraftCore;after:mod_BuildCraftEnergy;after:mod_IC2";
	}	
	
	@Override
	public void modsLoaded()
	{
		PowerConverterCore.afterModsLoaded();
		MinecraftForgeClient.preloadTexture(PowerConverterCore.terrainTexture);
	}
	
	@Override
	public void onPacketData(NetworkManager network, String channel, byte[] bytes)
	{
        DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(bytes));
        
        int[] intArray = null;
        float[] floatArray = null;
        String[] stringArray = null;
        
        try
        {
        	int i = dataStream.readInt();
        	int j = dataStream.readInt();
        	int k = dataStream.readInt();
        	int liqInt = dataStream.readInt();
        	
    		World w = ModLoader.getMinecraftInstance().theWorld;
    		TileEntity te = w.getBlockTileEntity(i, j, k);
    		if(te != null && te instanceof TileEntityLiquidGenerator)
    		{
    			((TileEntityLiquidGenerator)te).setStoredLiquid(liqInt);
    			w.markBlocksDirty(i, j, k, i, j, k);
    		}
        }
        catch(IOException e)
        {
                e.printStackTrace();
        }
    }
	
	public class ClientProxy implements IPCProxy
	{
		@Override
		public String getConfigPath()
		{
			return Minecraft.getMinecraftDir() + "/config/PowerConverters.cfg";
		}

		@Override
		public void sendPacketToAll(Packet packet)
		{
		}

		@Override
		public boolean isServer()
		{
			return false;
		}

		@Override
		public Packet getTileEntityPacket(TileEntity te, int liqInt)
		{
			return null;
		}

		@Override
		public boolean isClient(World world)
		{
			return world.isRemote;
		}

		@Override
		public void sendPacket(Packet packet)
		{
			ModLoader.sendPacket(packet);
		}
	}

	@Override
	public void onConnect(NetworkManager network)
	{
		MessageManager.getInstance().registerChannel(network, this, "PowConv");
	}

	@Override
	public void onLogin(NetworkManager network, Packet1Login login)
	{
	}

	@Override
	public void onDisconnect(NetworkManager network, String message, Object[] args)
	{
	}
}
