package net.minecraft.src;

import java.io.*;

import net.minecraft.src.forge.*;
import net.minecraft.src.powercrystals.powerconverters.*;

public class mod_PowerConverters extends NetworkMod implements IConnectionHandler, IPacketHandler
{
	private static mod_PowerConverters instance;
	
	@Override
	public String getVersion()
	{
		return PowerConverterCore.version;
	}
	@Override
	public void load()
	{
		instance = this;
		PowerConverterCore.init(new ServerProxy());
		
		MinecraftForge.registerConnectionHandler(this);
	}
	
	/** This is to force Power Converters to load after the required mods, IC2 and BC2 + BC2 Energy.
	  */
	@Override
	public String getPriorities()
	{
		return "after:mod_BuildCraftCore;after:mod_BuildCraftEnergy;after:mod_IC2";
	}	
	
	@Override
	public void modsLoaded()
	{
		PowerConverterCore.afterModsLoaded();
	}
	
	public class ServerProxy implements IPCProxy
	{
		@Override
		public String getConfigPath()
		{
			return "config/PowerConverters.cfg";
		}

		@Override
		public void sendPacketToAll(Packet packet)
		{
			ModLoader.getMinecraftServerInstance().configManager.sendPacketToAllPlayers(packet);
		}

		@Override
		public boolean isServer()
		{
			return true;
		}
		
		@Override
		public Packet getTileEntityPacket(TileEntity te, int liqInt)
		{
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(bytes);
            try
            {
            	data.writeInt(te.xCoord);
            	data.writeInt(te.yCoord);
            	data.writeInt(te.zCoord);
            	data.writeInt(liqInt);
            }
            catch(IOException e)
            {
                    e.printStackTrace();
            }

            Packet250CustomPayload packet = new Packet250CustomPayload();
            packet.channel = "PowConv";
            packet.data = bytes.toByteArray();
            packet.length = packet.data.length;

			return packet;
		}

		@Override
		public boolean isClient(World world)
		{
			return false;
		}

		@Override
		public void sendPacket(Packet packet)
		{
			ModLoader.getMinecraftServerInstance().configManager.sendPacketToAllPlayers(packet);
		}
	}
	
	@Override
	public void onPacketData(NetworkManager network, String channel, byte[] data)
	{
	}
	
	@Override
	public void onConnect(NetworkManager network)
	{
	}
	
	@Override
	public void onLogin(NetworkManager network, Packet1Login login)
	{
		MessageManager.getInstance().registerChannel(network, this, "PowConv");
	}
	
	@Override
	public void onDisconnect(NetworkManager network, String message, Object[] args)
	{
	}
}
