/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBee;
import forestry.api.core.ForestryAPI;
import forestry.api.liquids.LiquidContainer;
import forestry.api.liquids.LiquidManager;
import forestry.api.liquids.LiquidStack;
import forestry.core.EnumErrorCode;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.TileMachine;
import forestry.core.network.EntityNetData;
import forestry.core.network.GuiId;
import forestry.core.utils.ManagedInventory;
import forestry.core.utils.Orientations;
import forestry.core.utils.StringUtil;
import forestry.core.utils.TankSlot;
import java.util.Stack;

public class MachineAnalyzer
extends Machine {
    public static final int TIME_TO_ANALYZE = 500;
    public static final int HONEY_REQUIRED = 100;
    public static final short SLOT_ANALYZE = 0;
    public static final short SLOT_CAN = 1;
    public static final short SLOT_INPUT_1 = 2;
    public static final short SLOT_OUTPUT_1 = 8;
    private ManagedInventory inventory = new ManagedInventory(12, "Items");
    private int analyzeTime;
    private short analyzeSlot = 0;
    private short canSlot = 1;
    private short inputSlot1 = (short)2;
    private short outputSlot1 = (short)8;
    public LiquidStack resource = new LiquidStack(ForestryItem.liquidHoney, 100);
    @EntityNetData
    public TankSlot resourceTank = new TankSlot(10000);
    private Stack pendingProducts = new Stack();

    public MachineAnalyzer(TileMachine tile) {
        super(tile);
    }

    @Override
    public String getName() {
        return StringUtil.localize("tile.mill.4");
    }

    @Override
    public void openGui(yw player, io tile) {
        player.openGui((BaseMod)ForestryAPI.instance, GuiId.AnalyzerGUI.ordinal(), player.k, this.tile.j, this.tile.k, this.tile.l);
    }

    @Override
    public void writeToNBT(ady nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("AnalyzeTime", this.analyzeTime);
        this.resourceTank.writeToNBT(nbttagcompound);
        no nbttaglist = new no();
        aan[] pending = this.pendingProducts.toArray(new aan[this.pendingProducts.size()]);
        for (int i = 0; i < pending.length; ++i) {
            if (pending[i] == null) continue;
            ady nbttagcompound1 = new ady();
            nbttagcompound1.a("Slot", (byte)i);
            pending[i].b(nbttagcompound1);
            nbttaglist.a((gh)nbttagcompound1);
        }
        nbttagcompound.a("PendingProducts", (gh)nbttaglist);
        this.inventory.b(nbttagcompound);
    }

    @Override
    public void readFromNBT(ady nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.analyzeTime = nbttagcompound.f("AnalyzeTime");
        this.resourceTank.readFromNBT(nbttagcompound);
        no nbttaglist = nbttagcompound.n("PendingProducts");
        for (int i = 0; i < nbttaglist.d(); ++i) {
            ady nbttagcompound1 = (ady)nbttaglist.a(i);
            this.pendingProducts.add(aan.a((ady)nbttagcompound1));
        }
        this.inventory.a(nbttagcompound);
    }

    @Override
    public void updateServerSide() {
        LiquidContainer container;
        if (this.tryAddPending()) {
            return;
        }
        if (!this.pendingProducts.isEmpty()) {
            this.setErrorState(EnumErrorCode.NOSPACE);
            return;
        }
        if (this.k_(this.canSlot) != null && (container = LiquidManager.getLiquidContainer(this.k_(this.canSlot))) != null && this.resource.isLiquidEqual(container.liquid)) {
            this.a((int)this.canSlot, this.replenishByContainer(this.k_(this.canSlot), container, this.resourceTank));
            if (this.k_((int)this.canSlot).a <= 0) {
                this.a((int)this.canSlot, null);
            }
        }
        if (this.analyzeTime > 0 && this.k_(this.analyzeSlot) != null && BeeManager.beeInterface.isBee(this.k_(this.analyzeSlot))) {
            --this.analyzeTime;
            if (this.analyzeTime > 0) {
                this.setErrorState(EnumErrorCode.OK);
                return;
            }
            IBee individual = BeeManager.beeInterface.getBee(this.k_(this.analyzeSlot));
            if (individual == null) {
                return;
            }
            individual.analyze();
            ady nbttagcompound = new ady();
            individual.b(nbttagcompound);
            this.k_(this.analyzeSlot).d(nbttagcompound);
            this.pendingProducts.push(this.k_(this.analyzeSlot));
            this.a((int)this.analyzeSlot, null);
        } else {
            this.analyzeTime = 0;
            if (this.k_(this.analyzeSlot) != null) {
                return;
            }
            if (this.resourceTank.quantity < this.resource.liquidAmount) {
                this.setErrorState(EnumErrorCode.NORESOURCE);
                return;
            }
            for (int i = this.inputSlot1; i < this.outputSlot1; ++i) {
                if (this.k_(i) == null || !BeeManager.beeInterface.isBee(this.k_(i))) continue;
                IBee individual = BeeManager.beeInterface.getBee(this.k_(i));
                if (individual.isAnalyzed()) {
                    this.pendingProducts.push(this.k_(i));
                    this.a(i, null);
                    continue;
                }
                this.a((int)this.analyzeSlot, this.k_(i));
                this.a(i, null);
                this.resourceTank.empty(this.resource.liquidAmount, true);
                this.analyzeTime = 500;
                return;
            }
            this.setErrorState(EnumErrorCode.NOTHINGANALYZE);
        }
    }

    @Override
    public boolean doWork() {
        return false;
    }

    private boolean tryAddPending() {
        if (this.pendingProducts.isEmpty()) {
            return false;
        }
        aan next = (aan)this.pendingProducts.peek();
        if (this.inventory.tryAddStack(next, this.outputSlot1, this.inventory.a() - this.outputSlot1, true)) {
            this.pendingProducts.pop();
            return true;
        }
        return false;
    }

    @Override
    public boolean isWorking() {
        return this.analyzeTime > 0;
    }

    public int getProgressScaled(int i) {
        return this.analyzeTime * i / 500;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.quantity * i / 10000;
    }

    public aan getBeeOnDisplay() {
        if (this.k_(this.analyzeSlot) != null) {
            return this.k_(this.analyzeSlot);
        }
        return null;
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.analyzeTime = j;
                break;
            }
            case 1: {
                this.resourceTank.liquidId = j;
                break;
            }
            case 2: {
                this.resourceTank.quantity = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(dd container, wm iCrafting) {
        iCrafting.a(container, 0, this.analyzeTime);
        iCrafting.a(container, 1, this.resourceTank.liquidId);
        iCrafting.a(container, 2, this.resourceTank.quantity);
    }

    @Override
    public int a() {
        return this.inventory.a();
    }

    @Override
    public aan k_(int i) {
        return this.inventory.k_(i);
    }

    @Override
    public aan a(int i, int j) {
        return this.inventory.a(i, j);
    }

    @Override
    public void a(int i, aan itemstack) {
        this.inventory.a(i, itemstack);
    }

    @Override
    public int d() {
        return this.inventory.d();
    }

    @Override
    public aan b(int slot) {
        return this.inventory.b(slot);
    }

    @Override
    public aan extractItem(boolean doRemove, Orientations from) {
        aan product = null;
        for (int i = this.outputSlot1; i < this.inventory.a(); ++i) {
            if (this.inventory.k_(i) == null) continue;
            product = this.k_(i).k();
            if (!doRemove) break;
            this.k_((int)i).a = 0;
            this.a(i, null);
            break;
        }
        return product;
    }

    @Override
    public boolean addItem(aan stack, boolean doAdd, Orientations from) {
        if (!BeeManager.beeInterface.isBee(stack)) {
            LiquidContainer container = LiquidManager.getLiquidContainer(stack);
            if (container == null || !container.liquid.isLiquidEqual(this.resource)) {
                return false;
            }
            if (this.k_(this.canSlot) == null) {
                if (doAdd) {
                    this.a((int)this.canSlot, stack.k());
                    stack.a = 0;
                }
                return true;
            }
            int space = this.k_(this.canSlot).c() - this.k_((int)this.canSlot).a;
            if (space <= 0) {
                return false;
            }
            if (doAdd) {
                this.k_((int)this.canSlot).a += stack.a;
                stack.a -= space;
                if (stack.a < 0) {
                    stack.a = 0;
                }
                if (this.k_((int)this.canSlot).a > this.k_(this.canSlot).c()) {
                    this.k_((int)this.canSlot).a = this.k_(this.canSlot).c();
                }
            }
            return true;
        }
        for (int i = this.inputSlot1; i < this.outputSlot1; ++i) {
            if (this.k_(i) != null) continue;
            if (doAdd) {
                this.a(i, stack.k());
                stack.a = 0;
            }
            return true;
        }
        return false;
    }

    @Override
    public int getStartInventorySide(int side) {
        if (side == 0) {
            return this.outputSlot1;
        }
        if (side == 1) {
            return this.canSlot;
        }
        return this.inputSlot1;
    }

    @Override
    public int getSizeInventorySide(int side) {
        if (side == 1) {
            return 1;
        }
        if (side == 0) {
            return 4;
        }
        return 6;
    }

    @Override
    public int fill(Orientations from, int quantity, int id, boolean doFill) {
        if (this.resourceTank.quantity > 0 && this.resourceTank.liquidId != id) {
            return 0;
        }
        if (id != ForestryItem.liquidHoney.bQ) {
            return 0;
        }
        int used = this.resourceTank.fill(from, quantity, id, doFill);
        if (doFill && used > 0) {
            this.tile.sendNetworkUpdate();
        }
        return used;
    }

    @Override
    public int getCapacity() {
        return 10000;
    }

    @Override
    public TankSlot[] getLiquidContents() {
        return new TankSlot[]{this.resourceTank};
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(kw tile) {
            return new MachineAnalyzer((TileMachine)tile);
        }
    }
}

