/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.config;

import cpw.mods.fml.common.FMLCommonHandler;
import forestry.core.Proxy;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public class Version {
    private static final String VERSION = "1.4.8.4";
    private static final String REMOTE_VERSION_FILE = "http://bit.ly/forestryver";
    public static EnumUpdateState currentVersion = EnumUpdateState.CURRENT;
    public static final int FORGE_VERSION_MAJOR = 3;
    public static final int FORGE_VERSION_MINOR = 3;
    public static final int FORGE_VERSION_PATCH = 8;

    public static String getVersion() {
        return VERSION;
    }

    public static void versionCheck() {
        try {
            String location = REMOTE_VERSION_FILE;
            URLConnection conn = null;
            while (location != null && !location.isEmpty()) {
                URL url = new URL(location);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 6.0; ru; rv:1.9.0.11) Gecko/2009060215 Firefox/3.0.11 (.NET CLR 3.5.30729)");
                conn.connect();
                location = conn.getHeaderField("Location");
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String line = null;
            String mcVersion = Proxy.getMinecraftVersion();
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith(mcVersion) || !line.contains("Forestry") || !line.endsWith(Version.getVersion())) continue;
                FMLCommonHandler.instance().getFMLLogger().finer("Forestry: Using the latest version for Minecraft " + mcVersion);
                currentVersion = EnumUpdateState.CURRENT;
                return;
            }
            ModLoader.getLogger().warning("Forestry: Using outdated version for Minecraft " + mcVersion + ". Consider updating.");
            currentVersion = EnumUpdateState.OUTDATED;
        }
        catch (Exception e) {
            e.printStackTrace();
            ModLoader.getLogger().warning("Forestry: Unable to read from remote version authority.");
            currentVersion = EnumUpdateState.CONNECTION_ERROR;
        }
    }

    public static enum EnumUpdateState {
        CURRENT,
        OUTDATED,
        CONNECTION_ERROR;

    }
}

