/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import forestry.core.Proxy;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.TileMill;
import forestry.core.network.EntityNetData;

public abstract class Mill
extends Machine {
    protected TileMill tileMill;
    @EntityNetData
    public int charge = 0;
    @EntityNetData
    public float speed;
    @EntityNetData
    public int stage = 0;
    public float progress;

    public Mill(TileMill tile) {
        super(tile);
        this.tileMill = tile;
        this.speed = 0.01f;
    }

    @Override
    public void updateServerSide() {
        if (this.charge <= 0) {
            if (this.stage > 0) {
                this.progress += this.speed;
            }
            if ((double)this.progress > 0.5) {
                this.stage = 2;
            }
            if (this.progress > 1.0f) {
                this.progress = 0.0f;
                this.stage = 0;
            }
            return;
        }
        this.progress += this.speed;
        if (this.stage <= 0) {
            this.stage = 1;
        }
        if ((double)this.progress > 0.5 && this.stage == 1) {
            this.stage = 2;
            if (this.charge < 7 && !Proxy.isMultiplayerWorld()) {
                ++this.charge;
                this.tileMill.sendNetworkUpdate();
            }
        }
        if (this.progress > 1.0f) {
            this.progress = 0.0f;
            this.stage = 0;
            if (this.charge >= 7) {
                this.activate();
            }
        }
    }

    protected abstract void activate();

    @Override
    public boolean isWorking() {
        return this.charge != 0;
    }

    @Override
    public void getGUINetworkData(int i, int j) {
    }

    @Override
    public void sendGUINetworkData(dd container, wm iCrafting) {
    }
}

