/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosome;
import java.util.Random;

public class Chromosome
implements IChromosome {
    private IAllele primary;
    private IAllele secondary;

    private Chromosome() {
    }

    public Chromosome(IAllele allele) {
        this.primary = this.secondary = allele;
    }

    public Chromosome(IAllele primary, IAllele secondary) {
        this.primary = primary;
        this.secondary = secondary;
    }

    @Override
    public void a(ady nbttagcompound) {
        this.primary = AlleleManager.alleleList[nbttagcompound.f("PrimaryId")];
        this.secondary = AlleleManager.alleleList[nbttagcompound.f("SecondaryId")];
    }

    @Override
    public void b(ady nbttagcompound) {
        nbttagcompound.a("PrimaryId", this.primary.getId());
        nbttagcompound.a("SecondaryId", this.secondary.getId());
    }

    @Override
    public IAllele getPrimaryAllele() {
        return this.primary;
    }

    @Override
    public IAllele getSecondaryAllele() {
        return this.secondary;
    }

    @Override
    public IAllele getActiveAllele() {
        if (this.primary.isDominant()) {
            return this.primary;
        }
        if (this.secondary.isDominant()) {
            return this.secondary;
        }
        return this.primary;
    }

    @Override
    public IAllele getInactiveAllele() {
        if (!this.secondary.isDominant()) {
            return this.secondary;
        }
        if (!this.primary.isDominant()) {
            return this.primary;
        }
        return this.secondary;
    }

    public IAllele getRandomAllele(Random rand) {
        if (rand.nextBoolean()) {
            return this.primary;
        }
        return this.secondary;
    }

    public void overrideInvalidAlleles(IAllele template) {
        if (this.primary == null) {
            this.primary = template;
        }
        if (this.secondary == null) {
            this.secondary = template;
        }
    }

    public static Chromosome loadChromosomeFromNBT(ady compound) {
        Chromosome chromosome = new Chromosome();
        chromosome.a(compound);
        return chromosome;
    }
}

