/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy;

import forestry.api.circuits.ICircuitBoard;
import forestry.api.core.ForestryAPI;
import forestry.core.EnumErrorCode;
import forestry.core.TemperatureState;
import forestry.core.circuits.ItemCircuitBoard;
import forestry.core.config.Config;
import forestry.core.gadgets.Engine;
import forestry.core.gadgets.EngineFactory;
import forestry.core.gadgets.TileEngine;
import forestry.core.network.GuiId;
import forestry.core.utils.DelayTimer;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.ManagedInventory;
import forestry.plugins.PluginIC2;
import ic2.api.Direction;
import ic2.api.ElectricItem;
import ic2.api.EnergyNet;

public class EngineTin
extends Engine {
    private short batterySlot = 0;
    private ManagedInventory inventory = new ManagedInventory(1, "electrical");
    private ManagedInventory sockets = new ManagedInventory(1, "sockets");
    private boolean isAddedToEnergyNet = false;
    private int euStored = 0;
    private EuConfig euConfig = new EuConfig(6, 2, 12);
    private DelayTimer delayUpdateTimer = new DelayTimer();

    public EngineTin(TileEngine tile) {
        super(tile);
        this.setHints((String[])Config.hints.get("engine.tin"));
        this.maxEnergy = 10000;
        this.maxEnergyExtracted = 400;
        this.maxHeat = 3000;
    }

    @Override
    public void openGui(yw player, io tile) {
        player.openGui((BaseMod)ForestryAPI.instance, GuiId.EngineTinGUI.ordinal(), player.k, this.tile.j, this.tile.k, this.tile.l);
    }

    @Override
    public void readFromNBT(ady nbttagcompound) {
        ICircuitBoard chipset;
        super.readFromNBT(nbttagcompound);
        this.euStored = nbttagcompound.f("EngineEnergyStored");
        this.inventory.a(nbttagcompound);
        this.sockets.a(nbttagcompound);
        aan chip = this.sockets.k_(0);
        if (chip != null && (chipset = ItemCircuitBoard.getCircuitboard(chip)) != null) {
            chipset.onLoad(this.tile);
        }
    }

    @Override
    public void writeToNBT(ady nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("EngineEnergyStored", this.euStored);
        this.inventory.b(nbttagcompound);
        this.sockets.b(nbttagcompound);
    }

    @Override
    public int dissipateHeat() {
        TemperatureState tempState;
        if (this.heat <= 0) {
            return 0;
        }
        int loss = 0;
        if (!this.isBurning() || !this.tile.isActivated()) {
            ++loss;
        }
        if ((tempState = this.getTemperatureState()) == TemperatureState.OVERHEATING || tempState == TemperatureState.OPERATING_TEMPERATURE) {
            ++loss;
        }
        this.heat -= loss;
        return loss;
    }

    @Override
    public int generateHeat() {
        int gain = 0;
        if (this.tile.isActivated() && this.isBurning()) {
            ++gain;
            if ((double)this.storedEnergy / (double)this.maxEnergy > 0.5) {
                ++gain;
            }
        }
        this.addHeat(gain);
        return gain;
    }

    @Override
    public void updateServerSide() {
        if (!PluginIC2.instance.isAvailable()) {
            this.setErrorState(EnumErrorCode.NOENERGYNET);
            return;
        }
        if (!this.isAddedToEnergyNet) {
            EnergyNet.getForWorld(this.tile.i).addTileEntity(this.tile);
            this.isAddedToEnergyNet = true;
        }
        super.updateServerSide();
        if (this.forceCooldown) {
            this.setErrorState(EnumErrorCode.FORCEDCOOLDOWN);
            return;
        }
        if (this.inventory.k_(this.batterySlot) != null) {
            this.replenishFromBattery(this.batterySlot);
        }
        if (!this.delayUpdateTimer.delayPassed(this.tile.i, 80L)) {
            return;
        }
        if (this.currentOutput <= 0 && this.getErrorState() == EnumErrorCode.OK) {
            this.setErrorState(EnumErrorCode.NOFUEL);
        } else {
            this.setErrorState(EnumErrorCode.OK);
        }
    }

    @Override
    public void burn() {
        if (!this.tile.isActivated()) {
            return;
        }
        if (this.euStored >= this.euConfig.euForCycle) {
            this.currentOutput = this.euConfig.mjPerCycle;
            this.addEnergy(this.euConfig.mjPerCycle);
            this.euStored -= this.euConfig.euForCycle;
        }
    }

    private void replenishFromBattery(int slot) {
        if (this.euStored >= this.euConfig.euStorage) {
            return;
        }
        if (!this.tile.isActivated()) {
            return;
        }
        aan itemstack = this.inventory.k_(slot);
        if (itemstack == null) {
            return;
        }
        if (itemstack.c != PluginIC2.chargedReBattery.c && itemstack.c != PluginIC2.energyCrystal.c && itemstack.c != PluginIC2.lapotronCrystal.c) {
            return;
        }
        int space = this.euConfig.euStorage - this.euStored;
        if (space >= this.euConfig.euForCycle * 3) {
            space = this.euConfig.euForCycle * 3;
        }
        this.euStored += ElectricItem.discharge(itemstack, space, 2, true, false);
    }

    @Override
    public boolean isBurning() {
        return this.mayBurn() && this.euStored >= this.euConfig.euForCycle;
    }

    public int getStorageScaled(int i) {
        return this.euStored * i / this.euConfig.euStorage;
    }

    public EnumTankLevel rateLevel(int scaled) {
        if (scaled < 5) {
            return EnumTankLevel.EMPTY;
        }
        if (scaled < 30) {
            return EnumTankLevel.LOW;
        }
        if (scaled < 60) {
            return EnumTankLevel.MEDIUM;
        }
        if (scaled < 90) {
            return EnumTankLevel.HIGH;
        }
        return EnumTankLevel.MAXIMUM;
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.currentOutput = j;
                break;
            }
            case 1: {
                this.storedEnergy = j;
                break;
            }
            case 2: {
                this.heat = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(dd containerEngine, wm iCrafting) {
        iCrafting.a(containerEngine, 0, this.currentOutput);
        iCrafting.a(containerEngine, 1, this.storedEnergy);
        iCrafting.a(containerEngine, 2, this.heat);
    }

    public void changeEnergyConfig(int euChange, int mjChange, int storageChange) {
        this.euConfig.euForCycle += euChange;
        this.euConfig.mjPerCycle += mjChange;
        this.euConfig.euStorage += storageChange;
    }

    @Override
    public boolean acceptsEnergyFrom(kw emitter, Direction direction) {
        return true;
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.isAddedToEnergyNet;
    }

    @Override
    public boolean demandsEnergy() {
        if (this.tile.isActivated()) {
            return this.euStored < 2 * this.euConfig.euForCycle - 1;
        }
        return false;
    }

    @Override
    public int injectEnergy(Direction directionFrom, int amount) {
        if (!this.tile.isActivated()) {
            return amount;
        }
        int space = this.euConfig.euStorage - this.euStored;
        if (amount < space) {
            this.euStored += amount;
            return 0;
        }
        this.euStored = this.euConfig.euStorage;
        return amount - space;
    }

    @Override
    public int a() {
        return this.inventory.a();
    }

    @Override
    public aan k_(int i) {
        return this.inventory.k_(i);
    }

    @Override
    public aan a(int i, int j) {
        return this.inventory.a(i, j);
    }

    @Override
    public void a(int i, aan itemstack) {
        this.inventory.a(i, itemstack);
    }

    @Override
    public int d() {
        return this.inventory.d();
    }

    @Override
    public aan b(int slot) {
        return this.inventory.b(slot);
    }

    @Override
    public int getSocketCount() {
        return this.sockets.a();
    }

    @Override
    public aan getSocket(int slot) {
        return this.sockets.k_(slot);
    }

    @Override
    public void setSocket(int slot, aan stack) {
        ICircuitBoard chipset;
        if (stack != null && !ItemCircuitBoard.isChipset(stack)) {
            return;
        }
        if (this.sockets.k_(slot) != null && ItemCircuitBoard.isChipset(this.sockets.k_(slot)) && (chipset = ItemCircuitBoard.getCircuitboard(this.sockets.k_(slot))) != null) {
            chipset.onRemoval(this.tile);
        }
        if (stack == null) {
            this.sockets.a(slot, stack);
            return;
        }
        this.sockets.a(slot, stack);
        chipset = ItemCircuitBoard.getCircuitboard(stack);
        if (chipset != null) {
            chipset.onInsertion(this.tile);
        }
    }

    protected static class EuConfig {
        public int euForCycle;
        public int mjPerCycle;
        public int euStorage;

        public EuConfig(int euForCycle, int mjPerCycle, int euStorage) {
            this.euForCycle = euForCycle;
            this.mjPerCycle = mjPerCycle;
            this.euStorage = euStorage;
        }
    }

    public static class Factory
    extends EngineFactory {
        @Override
        public Engine createEngine(kw tile) {
            return new EngineTin((TileEngine)tile);
        }
    }
}

