/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.circuits;

import forestry.core.circuits.Circuit;
import forestry.core.gadgets.TileEngine;
import forestry.energy.EngineTin;

public abstract class CircuitElectricChange
extends Circuit {
    int euChange = 7;
    int mjChange = 2;

    public CircuitElectricChange(int id, boolean requiresDiscovery, String name, String usage, String[] descriptions) {
        super(id, requiresDiscovery, name, usage, descriptions);
    }

    protected void configureChange(int euChange, int mjChange) {
        this.euChange = euChange;
        this.mjChange = mjChange;
    }

    @Override
    public boolean isCircuitable(kw tile) {
        return tile instanceof TileEngine && ((TileEngine)tile).engine instanceof EngineTin;
    }

    @Override
    public void onInsertion(kw tile) {
        if (!this.isCircuitable(tile)) {
            return;
        }
        EngineTin engine = (EngineTin)((TileEngine)tile).engine;
        engine.changeEnergyConfig(this.euChange, this.mjChange, 2 * this.euChange);
    }

    @Override
    public void onLoad(kw tile) {
        this.onInsertion(tile);
    }

    @Override
    public void onRemoval(kw tile) {
        if (!this.isCircuitable(tile)) {
            return;
        }
        EngineTin engine = (EngineTin)((TileEngine)tile).engine;
        engine.changeEnergyConfig(-this.euChange, -this.mjChange, -(2 * this.euChange));
    }

    @Override
    public void onTick(kw tile) {
    }
}

