/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import forestry.api.core.ForestryAPI;
import forestry.core.EnumErrorCode;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.TileMachine;
import forestry.core.network.EntityNetData;
import forestry.core.network.GuiId;
import forestry.core.triggers.Trigger;
import forestry.core.utils.ManagedInventory;
import forestry.core.utils.Orientations;
import forestry.core.utils.StackUtils;
import forestry.mail.IStamps;
import forestry.mail.PostOffice;
import forestry.plugins.PluginForestryMail;
import java.util.LinkedList;

public class MachineTrader
extends Machine {
    @EntityNetData
    public String moniker = "";

    public MachineTrader(TileMachine tile) {
        super(tile);
    }

    @Override
    public String getName() {
        return "tile.mill.6";
    }

    @Override
    public void openGui(yw player, io tile) {
        if (this.isLinked()) {
            player.openGui((BaseMod)ForestryAPI.instance, GuiId.TraderGUI.ordinal(), this.tile.i, this.tile.j, this.tile.k, this.tile.l);
        } else {
            player.openGui((BaseMod)ForestryAPI.instance, GuiId.TraderNameGUI.ordinal(), this.tile.i, this.tile.j, this.tile.k, this.tile.l);
        }
    }

    @Override
    public void onRemoval() {
        if (this.isLinked()) {
            PostOffice.deleteTradeStation(this.tile.i, this.moniker);
        }
    }

    @Override
    public void writeToNBT(ady nbttagcompound) {
        if (this.moniker != null) {
            nbttagcompound.a("MNK", this.moniker);
        }
    }

    @Override
    public void readFromNBT(ady nbttagcompound) {
        if (nbttagcompound.c("MNK")) {
            this.moniker = nbttagcompound.j("MNK");
        }
    }

    @Override
    public void updateServerSide() {
        if (this.tile.i.w() % 20L * 10L != 0L) {
            return;
        }
        this.setErrorState(EnumErrorCode.OK);
        if (!this.hasPaperMin(0.0f) || !this.hasInputBufMin(0.0f)) {
            this.setErrorState(EnumErrorCode.NORESOURCE);
            return;
        }
        if (!this.hasPostageMin(2)) {
            this.setErrorState(EnumErrorCode.NOSTAMPS);
            return;
        }
    }

    @Override
    public boolean doWork() {
        return false;
    }

    @Override
    public boolean isWorking() {
        return false;
    }

    public boolean isLinked() {
        return this.getMoniker() != null && !this.getMoniker().isEmpty();
    }

    private float percentOccupied(int startSlot, int countSlots) {
        int max = 0;
        int avail = 0;
        io tradeInventory = this.getOrCreateTradeInventory();
        for (int i = startSlot; i < startSlot + countSlots; ++i) {
            max += 64;
            if (tradeInventory.k_(i) == null) continue;
            avail += tradeInventory.k_((int)i).a;
        }
        return (float)avail / (float)max;
    }

    public boolean hasPaperMin(float percentage) {
        return this.percentOccupied(5, 6) > percentage;
    }

    public boolean hasInputBufMin(float percentage) {
        return this.percentOccupied(15, 12) > percentage;
    }

    public boolean hasOutputBufMin(float percentage) {
        return this.percentOccupied(27, 12) > percentage;
    }

    public boolean hasPostageMin(int postage) {
        int posted = 0;
        io tradeInventory = this.getOrCreateTradeInventory();
        for (int i = 11; i < 15; ++i) {
            aan stamp = tradeInventory.k_(i);
            if (stamp == null || !(stamp.a() instanceof IStamps)) continue;
            posted += ((IStamps)stamp.a()).getPostage(stamp).getValue() * stamp.a;
        }
        return posted >= postage;
    }

    public String getMoniker() {
        return this.moniker;
    }

    public void setMoniker(String moniker) {
        if (!PostOffice.isValidTradeMoniker(this.tile.i, moniker)) {
            this.setErrorState(EnumErrorCode.NOTALPHANUMERIC);
            return;
        }
        if (!PostOffice.isAvailableTradeMoniker(this.tile.i, moniker)) {
            this.setErrorState(EnumErrorCode.NOTUNIQUE);
            return;
        }
        this.moniker = moniker;
        PostOffice.getOrCreateTradeStation(this.tile.i, this.tile.getOwnerName(), this.moniker);
        this.setErrorState(EnumErrorCode.OK);
        this.tile.sendNetworkUpdate();
    }

    @Override
    public void getGUINetworkData(int i, int j) {
    }

    @Override
    public void sendGUINetworkData(dd container, wm iCrafting) {
    }

    public io getOrCreateTradeInventory() {
        if (this.moniker == null || this.moniker.isEmpty()) {
            return new ManagedInventory(39, "INV");
        }
        return PostOffice.getOrCreateTradeStation(this.tile.i, this.tile.getOwnerName(), this.moniker);
    }

    @Override
    public boolean addItem(aan stack, boolean doAdd, Orientations from) {
        if (!this.isLinked()) {
            return false;
        }
        io inventory = this.getOrCreateTradeInventory();
        aan tradegood = inventory.k_(0);
        if (stack.c == yr.aK.bQ && (tradegood != null && tradegood.c != yr.aK.bQ || from == Orientations.YNeg || from == Orientations.YPos)) {
            return StackUtils.stowInInventory(stack, inventory, doAdd, 5, 6);
        }
        if (stack.a() instanceof IStamps && (tradegood != null && !(tradegood.a() instanceof IStamps) || from == Orientations.YNeg || from == Orientations.YPos)) {
            return StackUtils.stowInInventory(stack, inventory, doAdd, 11, 4);
        }
        if (tradegood == null) {
            return false;
        }
        if (!tradegood.a(stack)) {
            return false;
        }
        return StackUtils.stowInInventory(stack, inventory, doAdd, 15, 12);
    }

    @Override
    public aan extractItem(boolean doRemove, Orientations from) {
        aan product = null;
        if (!this.isLinked()) {
            return product;
        }
        io inventory = this.getOrCreateTradeInventory();
        for (int i = 27; i < 39; ++i) {
            aan stackSlot = inventory.k_(i);
            if (stackSlot == null || stackSlot.a <= 0) continue;
            product = inventory.a(i, 1);
            break;
        }
        return product;
    }

    @Override
    public int getStartInventorySide(int side) {
        switch (side) {
            case 0: {
                return 5;
            }
            case 1: {
                return 11;
            }
            case 2: 
            case 4: {
                return 15;
            }
            case 3: 
            case 5: {
                return 27;
            }
        }
        return 0;
    }

    @Override
    public int getSizeInventorySide(int side) {
        switch (side) {
            case 0: {
                return 6;
            }
            case 1: {
                return 4;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return 12;
            }
        }
        return 0;
    }

    @Override
    public int a() {
        return this.getOrCreateTradeInventory().a();
    }

    @Override
    public aan k_(int i) {
        return this.getOrCreateTradeInventory().k_(i);
    }

    @Override
    public aan a(int i, int j) {
        return this.getOrCreateTradeInventory().a(i, j);
    }

    @Override
    public void a(int i, aan itemstack) {
        this.getOrCreateTradeInventory().a(i, itemstack);
    }

    @Override
    public aan b(int slot) {
        return this.getOrCreateTradeInventory().b(slot);
    }

    @Override
    public void j() {
        this.getOrCreateTradeInventory().j();
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(PluginForestryMail.lowPaper25);
        res.add(PluginForestryMail.lowPaper10);
        res.add(PluginForestryMail.lowInput25);
        res.add(PluginForestryMail.lowInput10);
        res.add(PluginForestryMail.lowPostage40);
        res.add(PluginForestryMail.lowPostage20);
        res.add(PluginForestryMail.highBuffer90);
        res.add(PluginForestryMail.highBuffer75);
        return res;
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(kw tile) {
            return new MachineTrader((TileMachine)tile);
        }
    }
}

