/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.apiculture.EnumBeeSpecies;

public enum EnumMutation {
    COMMON_A(EnumBeeSpecies.FOREST, EnumBeeSpecies.MEADOWS, EnumBeeSpecies.COMMON, 25, false),
    CULTIVATED_A(EnumBeeSpecies.COMMON, EnumBeeSpecies.MEADOWS, EnumBeeSpecies.CULTIVATED, 10, false),
    CULTIVATED_B(EnumBeeSpecies.COMMON, EnumBeeSpecies.FOREST, EnumBeeSpecies.CULTIVATED, 10, false),
    NOBLE_A(EnumBeeSpecies.CULTIVATED, EnumBeeSpecies.FOREST, EnumBeeSpecies.NOBLE, 2, false),
    NOBLE_B(EnumBeeSpecies.CULTIVATED, EnumBeeSpecies.COMMON, EnumBeeSpecies.NOBLE, 12, false),
    MAJESTIC_A(EnumBeeSpecies.NOBLE, EnumBeeSpecies.CULTIVATED, EnumBeeSpecies.MAJESTIC, 8, false),
    IMPERIAL_A(EnumBeeSpecies.MAJESTIC, EnumBeeSpecies.NOBLE, EnumBeeSpecies.IMPERIAL, 8, false),
    IMPERIAL_B(EnumBeeSpecies.MAJESTIC, EnumBeeSpecies.CULTIVATED, EnumBeeSpecies.IMPERIAL, 2, false),
    DILIGENT_A(EnumBeeSpecies.CULTIVATED, EnumBeeSpecies.MEADOWS, EnumBeeSpecies.DILIGENT, 2, false),
    DILIGENT_B(EnumBeeSpecies.CULTIVATED, EnumBeeSpecies.COMMON, EnumBeeSpecies.DILIGENT, 12, false),
    UNWEARY_A(EnumBeeSpecies.DILIGENT, EnumBeeSpecies.CULTIVATED, EnumBeeSpecies.UNWEARY, 8, false),
    INDUSTRIOUS_A(EnumBeeSpecies.UNWEARY, EnumBeeSpecies.DILIGENT, EnumBeeSpecies.INDUSTRIOUS, 8, false),
    INDUSTRIOUS_B(EnumBeeSpecies.UNWEARY, EnumBeeSpecies.CULTIVATED, EnumBeeSpecies.INDUSTRIOUS, 2, false),
    SINISTER_A(EnumBeeSpecies.CULTIVATED, EnumBeeSpecies.COMMON, EnumBeeSpecies.SINISTER, 32, false, abn.j.M),
    FIENDISH_A(EnumBeeSpecies.CULTIVATED, EnumBeeSpecies.SINISTER, EnumBeeSpecies.FIENDISH, 8, false, abn.j.M),
    DEMONIC_A(EnumBeeSpecies.FIENDISH, EnumBeeSpecies.SINISTER, EnumBeeSpecies.DEMONIC, 8, false, abn.j.M),
    CULTIVATED_SPAWN_A(EnumBeeSpecies.COMMON, EnumBeeSpecies.COMMON, EnumBeeSpecies.CULTIVATED, 5, true),
    NOBLE_SPAWN_A(EnumBeeSpecies.CULTIVATED, EnumBeeSpecies.CULTIVATED, EnumBeeSpecies.NOBLE, 5, true),
    MAJESTIC_SPAWN_A(EnumBeeSpecies.NOBLE, EnumBeeSpecies.NOBLE, EnumBeeSpecies.MAJESTIC, 5, true),
    IMPERIAL_SPAWN_A(EnumBeeSpecies.MAJESTIC, EnumBeeSpecies.MAJESTIC, EnumBeeSpecies.IMPERIAL, 5, true),
    DILIGENT_SPAWN_A(EnumBeeSpecies.CULTIVATED, EnumBeeSpecies.CULTIVATED, EnumBeeSpecies.DILIGENT, 5, true),
    UNWEARY_SPAWN_A(EnumBeeSpecies.DILIGENT, EnumBeeSpecies.DILIGENT, EnumBeeSpecies.UNWEARY, 5, true),
    INDUSTRIOUS_SPAWN_A(EnumBeeSpecies.UNWEARY, EnumBeeSpecies.UNWEARY, EnumBeeSpecies.INDUSTRIOUS, 5, true);

    private final EnumBeeSpecies allele1;
    private final EnumBeeSpecies allele2;
    private final EnumBeeSpecies mutated;
    private final int chance;
    private final boolean spawn;
    private final int biomeId;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private EnumMutation(EnumBeeSpecies allele1, int allele2, boolean mutated) {
        this((String)var1_-1, (int)var2_-1, allele1, (EnumBeeSpecies)allele2, (EnumBeeSpecies)mutated, (int)chance, (boolean)spawn, 0);
        void spawn;
        void chance;
        void var2_-1;
        void var1_-1;
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private EnumMutation(EnumBeeSpecies allele1, int allele2, boolean mutated, int chance) {
        void biomeId;
        void spawn;
        this.allele1 = allele1;
        this.allele2 = (EnumBeeSpecies)allele2;
        this.mutated = (EnumBeeSpecies)mutated;
        this.chance = chance;
        this.spawn = spawn;
        this.biomeId = biomeId;
    }

    public int chanceToMutate(EnumBeeSpecies species1, EnumBeeSpecies species2) {
        if (species1 == this.allele1 && species2 == this.allele2) {
            return this.chance;
        }
        if (species2 == this.allele1 && species1 == this.allele2) {
            return this.chance;
        }
        return 0;
    }

    public boolean hasAllele(EnumBeeSpecies species) {
        return this.allele1 == species || this.allele2 == species;
    }

    public EnumBeeSpecies getMutated() {
        return this.mutated;
    }

    public boolean getSpawn() {
        return this.spawn;
    }

    public int getChance() {
        return this.chance;
    }

    public int getBiome() {
        return this.biomeId;
    }

    public EnumBeeSpecies getOther(EnumBeeSpecies other) {
        if (this.allele1 != other) {
            return this.allele1;
        }
        return this.allele2;
    }
}

