/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.BeeManager;
import forestry.api.core.ForestryAPI;
import forestry.core.config.Config;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.TileMachine;
import forestry.core.network.GuiId;
import forestry.core.utils.Orientations;
import forestry.core.utils.StringUtil;

public class MachineApiaristChest
extends Machine {
    private aan[] inventoryStacks = new aan[125];

    public MachineApiaristChest(TileMachine tile) {
        super(tile);
        this.setHints((String[])Config.hints.get("apiarist.chest"));
    }

    @Override
    public String getName() {
        return StringUtil.localize("tile.mill.3");
    }

    @Override
    public void openGui(yw player, io tile) {
        player.openGui((BaseMod)ForestryAPI.instance, GuiId.ApiaristChestGUI.ordinal(), player.k, this.tile.j, this.tile.k, this.tile.l);
    }

    @Override
    public void writeToNBT(ady nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        no nbttaglist = new no();
        for (int i = 0; i < this.inventoryStacks.length; ++i) {
            if (this.inventoryStacks[i] == null) continue;
            ady nbttagcompound1 = new ady();
            nbttagcompound1.a("Slot", (byte)i);
            this.inventoryStacks[i].b(nbttagcompound1);
            nbttaglist.a((gh)nbttagcompound1);
        }
        nbttagcompound.a("Items", (gh)nbttaglist);
    }

    @Override
    public void readFromNBT(ady nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        no nbttaglist = nbttagcompound.n("Items");
        this.inventoryStacks = new aan[this.a()];
        for (int i = 0; i < nbttaglist.d(); ++i) {
            ady nbttagcompound1 = (ady)nbttaglist.a(i);
            byte byte0 = nbttagcompound1.d("Slot");
            if (byte0 < 0 || byte0 >= this.inventoryStacks.length) continue;
            this.inventoryStacks[byte0] = aan.a((ady)nbttagcompound1);
        }
    }

    @Override
    public void updateServerSide() {
    }

    @Override
    public boolean doWork() {
        return false;
    }

    @Override
    public boolean isWorking() {
        return false;
    }

    @Override
    public boolean throwsErrors() {
        return false;
    }

    @Override
    public boolean addItem(aan stack, boolean doAdd, Orientations from) {
        if (!BeeManager.beeInterface.isBee(stack)) {
            return false;
        }
        int freeSlots = 0;
        int slot = -1;
        for (int i = 0; i < this.a(); ++i) {
            int space;
            if (this.k_(i) == null) {
                ++freeSlots;
                if (slot >= 0) continue;
                slot = i;
                continue;
            }
            if (!this.k_(i).a(stack) || (space = this.k_(i).c() - this.k_((int)i).a) <= 0) continue;
            if (space < stack.a) {
                if (doAdd) {
                    this.k_((int)i).a = this.k_(i).c();
                    stack.a -= space;
                    continue;
                }
                return true;
            }
            if (doAdd) {
                this.k_((int)i).a += stack.a;
                stack.a = 0;
            }
            return true;
        }
        if (freeSlots <= 0) {
            return false;
        }
        if (doAdd) {
            this.a(slot, stack.k());
            stack.a = 0;
        }
        return true;
    }

    @Override
    public aan extractItem(boolean doRemove, Orientations from) {
        aan product = null;
        for (int i = 0; i < this.a(); ++i) {
            if (this.k_(i) == null) continue;
            product = this.k_(i).k();
            if (!doRemove) break;
            this.k_((int)i).a = 0;
            this.a(i, null);
            break;
        }
        return product;
    }

    @Override
    public int a() {
        return this.inventoryStacks.length;
    }

    @Override
    public aan k_(int i) {
        return this.inventoryStacks[i];
    }

    @Override
    public aan a(int i, int j) {
        if (this.inventoryStacks[i] == null) {
            return null;
        }
        if (this.inventoryStacks[i].a <= j) {
            aan product = this.inventoryStacks[i];
            this.inventoryStacks[i] = null;
            return product;
        }
        aan product = this.inventoryStacks[i].a(j);
        if (this.inventoryStacks[i].a == 0) {
            this.inventoryStacks[i] = null;
        }
        return product;
    }

    @Override
    public void a(int i, aan itemstack) {
        this.inventoryStacks[i] = itemstack;
        if (itemstack != null && itemstack.a > this.d()) {
            itemstack.a = this.d();
        }
    }

    @Override
    public aan b(int slot) {
        if (this.inventoryStacks[slot] == null) {
            return null;
        }
        aan toReturn = this.inventoryStacks[slot];
        this.inventoryStacks[slot] = null;
        return toReturn;
    }

    @Override
    public void getGUINetworkData(int i, int j) {
    }

    @Override
    public void sendGUINetworkData(dd container, wm iCrafting) {
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(kw tile) {
            return new MachineApiaristChest((TileMachine)tile);
        }
    }
}

