/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.IAlleleSpecies;
import forestry.core.genetics.Allele;
import forestry.core.utils.StringUtil;

public class AlleleSpecies
extends Allele
implements IAlleleSpecies {
    private String name;
    private String binomial;
    private boolean hasEffect = false;
    private boolean isSecret = false;
    private boolean isCounted = true;
    private int primaryColor;
    private int secondaryColor;
    private aeb achievement = null;
    private EnumTemperature climate = EnumTemperature.NORMAL;
    private EnumHumidity humidity = EnumHumidity.NORMAL;

    public AlleleSpecies(int id, boolean isDominant, String name, String binomial, int primaryColor, int secondaryColor) {
        super(id, isDominant);
        this.name = name;
        this.binomial = binomial;
        this.primaryColor = primaryColor;
        this.secondaryColor = secondaryColor;
    }

    @Override
    public String getName() {
        return StringUtil.localize(this.name);
    }

    @Override
    public int getPrimaryColor() {
        return this.primaryColor;
    }

    @Override
    public int getSecondaryColor() {
        return this.secondaryColor;
    }

    @Override
    public EnumTemperature getTemperature() {
        return this.climate;
    }

    @Override
    public EnumHumidity getHumidity() {
        return this.humidity;
    }

    @Override
    public boolean hasEffect() {
        return this.hasEffect;
    }

    @Override
    public boolean isSecret() {
        return this.isSecret;
    }

    @Override
    public boolean isCounted() {
        return this.isCounted;
    }

    @Override
    public String getBinomial() {
        return this.binomial;
    }

    @Override
    public aeb getAchievement() {
        return this.achievement;
    }

    public AlleleSpecies setTemperature(EnumTemperature temperature) {
        this.climate = temperature;
        return this;
    }

    public AlleleSpecies setHumidity(EnumHumidity humidity) {
        this.humidity = humidity;
        return this;
    }

    public AlleleSpecies setHasEffect() {
        this.hasEffect = true;
        return this;
    }

    public AlleleSpecies setIsSecret() {
        this.isSecret = true;
        return this;
    }

    public AlleleSpecies setIsNotCounted() {
        this.isCounted = false;
        return this;
    }

    public AlleleSpecies setAchievement(aeb achievement) {
        this.achievement = achievement;
        return this;
    }
}

