/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.core.Proxy;
import java.io.InputStream;
import java.util.Properties;

public class Localization {
    public static Localization instance = new Localization();
    private static final String DEFAULT_LANGUAGE = "en_US";
    private String loadedLanguage = null;
    private Properties defaultMappings = new Properties();
    private Properties mappings = new Properties();

    public Localization() {
        this.load(Localization.getCurrentLanguage());
    }

    public synchronized String get(String key) {
        String currentLanguage = Localization.getCurrentLanguage();
        if (currentLanguage == null || !currentLanguage.equals(this.loadedLanguage)) {
            this.load(currentLanguage);
        }
        return this.mappings.getProperty(key, this.defaultMappings.getProperty(key, key));
    }

    private void load(String newLanguage) {
        this.defaultMappings.clear();
        this.mappings.clear();
        try {
            InputStream langStream = Localization.class.getResourceAsStream("/lang/forestry/" + newLanguage + ".properties");
            InputStream defaultLangStream = Localization.class.getResourceAsStream("/lang/forestry/en_US.properties");
            this.mappings.load(langStream == null ? defaultLangStream : langStream);
            this.defaultMappings.load(defaultLangStream);
            if (langStream != null) {
                langStream.close();
            }
            defaultLangStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.loadedLanguage = newLanguage;
    }

    private static String getCurrentLanguage() {
        return Proxy.getCurrentLanguage();
    }
}

