/*
 * Decompiled with CFR 0.152.
 */
package forestry.cultivation;

import forestry.api.core.ForestryBlock;
import forestry.core.RenderProxy;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.MachinePackage;
import forestry.core.utils.CraftingIngredients;
import forestry.core.utils.EnergyConfiguration;
import forestry.core.utils.StructureBlueprint;
import forestry.core.utils.TextureDescription;
import forestry.cultivation.MillForester;
import forestry.cultivation.MillTreetap;
import forestry.cultivation.ProxyCultivation;
import forestry.cultivation.harvesters.HarvesterCacti;
import forestry.cultivation.harvesters.HarvesterHerbaceous;
import forestry.cultivation.harvesters.HarvesterMushroom;
import forestry.cultivation.harvesters.HarvesterNetherwart;
import forestry.cultivation.harvesters.HarvesterPeat;
import forestry.cultivation.harvesters.HarvesterReeds;
import forestry.cultivation.harvesters.HarvesterRubber;
import forestry.cultivation.harvesters.HarvesterSapling;
import forestry.cultivation.harvesters.HarvesterSeeds;
import forestry.cultivation.planters.PlanterBog;
import forestry.cultivation.planters.PlanterHerbaceous;
import forestry.cultivation.planters.PlanterMushroom;
import forestry.cultivation.planters.PlanterNetherwarts;
import forestry.cultivation.planters.PlanterRubber;
import forestry.cultivation.planters.PlanterSaplings;
import forestry.cultivation.planters.PlanterSeeds;
import forestry.plugins.PluginIC2;

public class PackagesCultivation {
    public static final EnergyConfiguration energyConfigDefaultPlanter = new EnergyConfiguration(500, 10, 30, 30, 500);
    public static final EnergyConfiguration energyConfigDefaultHarvester = new EnergyConfiguration(500, 20, 40, 40, 500);
    public static final EnergyConfiguration energyConfigDefaultGrower = new EnergyConfiguration(1000, 10, 200, 200, 500);

    public static MachinePackage getArboretumPackage() {
        CraftingIngredients recipe = null;
        if (Config.craftingFarmsEnabled) {
            recipe = new CraftingIngredients(1, new Object[]{"#X#", "XYX", "#Z#", Character.valueOf('#'), pb.M, Character.valueOf('X'), new aan(ForestryItem.tubes, 1, 4), Character.valueOf('Y'), ForestryItem.sturdyMachine, Character.valueOf('Z'), new aan(ForestryItem.circuitboards, 1, 0)});
        }
        MachinePackage pack = new MachinePackage((MachineFactory)new PlanterSaplings.Factory(), "Arboretum", ProxyCultivation.getRenderDefaultPlanter("/gfx/forestry/blocks/arboretum_"), recipe);
        pack.blueprints.add(StructureBlueprint.defaultArboretum);
        pack.blueprints.add(PlanterSaplings.defaultSoil);
        pack.blueprints.add(PlanterSaplings.defaultPlantation);
        pack.energyConfig = energyConfigDefaultPlanter;
        return pack;
    }

    public static MachinePackage getFarmPackage() {
        CraftingIngredients recipe = null;
        if (Config.craftingFarmsEnabled) {
            recipe = new CraftingIngredients(1, new Object[]{"#X#", "XYX", "#Z#", Character.valueOf('#'), pb.M, Character.valueOf('X'), new aan(ForestryItem.tubes, 1, 2), Character.valueOf('Y'), ForestryItem.sturdyMachine, Character.valueOf('Z'), new aan(ForestryItem.circuitboards, 1, 0)});
        }
        MachinePackage pack = new MachinePackage((MachineFactory)new PlanterSeeds.Factory(), "Farm", ProxyCultivation.getRenderDefaultPlanter("/gfx/forestry/blocks/farm_"), recipe);
        pack.blueprints.add(StructureBlueprint.defaultFarm);
        pack.blueprints.add(PlanterSeeds.farmSoil);
        pack.blueprints.add(PlanterSeeds.wheatPlantation);
        pack.energyConfig = energyConfigDefaultPlanter;
        return pack;
    }

    public static MachinePackage getPlantationPackage() {
        CraftingIngredients recipe = null;
        MachinePackage pack = new MachinePackage((MachineFactory)new PlanterRubber.Factory(), "Rubber Plantation", ProxyCultivation.getRenderDefaultPlanter("/gfx/forestry/blocks/plantation_"), recipe);
        pack.blueprints.add(StructureBlueprint.defaultArboretum);
        pack.blueprints.add(PlanterRubber.rubberSoil);
        pack.blueprints.add(PlanterRubber.rubberPlantation);
        pack.energyConfig = energyConfigDefaultPlanter;
        return pack;
    }

    public static MachinePackage getPumpkinFarmPackage() {
        CraftingIngredients recipe = null;
        if (Config.craftingFarmsEnabled) {
            recipe = new CraftingIngredients(1, new Object[]{"Z#X", "#Y#", "X#Z", Character.valueOf('#'), pb.M, Character.valueOf('X'), pb.ba, Character.valueOf('Z'), pb.br, Character.valueOf('Y'), new aan(ForestryBlock.planter, 1, 0)});
        }
        MachinePackage pack = new MachinePackage((MachineFactory)new PlanterHerbaceous.Factory(), "Pumpkin Farm", ProxyCultivation.getRenderDefaultPlanter("/gfx/forestry/blocks/pumpkinfarm_"), recipe);
        pack.blueprints.add(PlanterHerbaceous.pumpkinArea);
        pack.blueprints.add(PlanterHerbaceous.pumpkinSoil);
        pack.blueprints.add(PlanterHerbaceous.pumpkinFarm);
        pack.energyConfig = energyConfigDefaultPlanter;
        return pack;
    }

    public static MachinePackage getBogPeatPackage() {
        CraftingIngredients recipe = null;
        if (Config.craftingFarmsEnabled) {
            recipe = new CraftingIngredients(1, new Object[]{"#X#", "XYX", "#Z#", Character.valueOf('#'), pb.M, Character.valueOf('X'), new aan(ForestryItem.tubes, 1, 0), Character.valueOf('Y'), ForestryItem.sturdyMachine, Character.valueOf('Z'), new aan(ForestryItem.circuitboards, 1, 0)});
        }
        MachinePackage pack = new MachinePackage((MachineFactory)new PlanterBog.Factory(), "Peat Bog", ProxyCultivation.getRenderDefaultPlanter("/gfx/forestry/blocks/peatbog_"), recipe);
        pack.blueprints.add(StructureBlueprint.defaultFarm);
        pack.blueprints.add(PlanterBog.bogEarth);
        pack.energyConfig = energyConfigDefaultPlanter;
        return pack;
    }

    public static MachinePackage getMushroomFarmPackage() {
        CraftingIngredients recipe = null;
        if (Config.craftingFarmsEnabled) {
            recipe = new CraftingIngredients(1, new Object[]{"X#Z", "#Y#", "Z#X", Character.valueOf('#'), pb.M, Character.valueOf('X'), pb.af, Character.valueOf('Z'), pb.ag, Character.valueOf('Y'), new aan(ForestryBlock.planter, 1, 0)});
        }
        MachinePackage pack = new MachinePackage((MachineFactory)new PlanterMushroom.Factory(), "Mushroom Farm", ProxyCultivation.getRenderDefaultPlanter("/gfx/forestry/blocks/mushroomfarm_"), recipe);
        pack.blueprints.add(PlanterMushroom.defaultShroom);
        pack.blueprints.add(PlanterMushroom.defaultSoil);
        pack.blueprints.add(PlanterMushroom.defaultPlantation);
        pack.energyConfig = energyConfigDefaultPlanter;
        return pack;
    }

    public static MachinePackage getNetherFarmPackage() {
        CraftingIngredients recipe = null;
        if (Config.craftingFarmsEnabled) {
            recipe = new CraftingIngredients(1, new Object[]{"X#X", "#Y#", "X#X", Character.valueOf('#'), pb.M, Character.valueOf('X'), yr.br, Character.valueOf('Y'), new aan(ForestryBlock.planter, 1, 0)});
        }
        MachinePackage pack = new MachinePackage((MachineFactory)new PlanterNetherwarts.Factory(), "Netherwart Farm", ProxyCultivation.getRenderDefaultPlanter("/gfx/forestry/blocks/netherfarm_"), recipe);
        pack.blueprints.add(StructureBlueprint.defaultArboretum);
        pack.blueprints.add(PlanterNetherwarts.netherwartSoil);
        pack.blueprints.add(PlanterNetherwarts.netherwartPlantation);
        pack.energyConfig = energyConfigDefaultPlanter;
        return pack;
    }

    public static MachinePackage getLoggerPackage() {
        CraftingIngredients recipe = null;
        if (Config.craftingFarmsEnabled) {
            recipe = new CraftingIngredients(1, new Object[]{"#X#", "XYX", "#Z#", Character.valueOf('#'), pb.M, Character.valueOf('X'), new aan(ForestryItem.tubes, 1, 5), Character.valueOf('Y'), ForestryItem.sturdyMachine, Character.valueOf('Z'), new aan(ForestryItem.circuitboards, 1, 0)});
        }
        MachinePackage pack = new MachinePackage((MachineFactory)new HarvesterSapling.Factory(), "Logger", new TextureDescription(48, 49, 50, 51, 52, 53), recipe);
        pack.energyConfig = energyConfigDefaultHarvester;
        return pack;
    }

    public static MachinePackage getCombinePackage() {
        CraftingIngredients recipe = null;
        if (Config.craftingFarmsEnabled) {
            recipe = new CraftingIngredients(1, new Object[]{"#X#", "XYX", "#Z#", Character.valueOf('#'), pb.M, Character.valueOf('X'), new aan(ForestryItem.tubes, 1, 3), Character.valueOf('Y'), ForestryItem.sturdyMachine, Character.valueOf('Z'), new aan(ForestryItem.circuitboards, 1, 0)});
        }
        MachinePackage pack = new MachinePackage((MachineFactory)new HarvesterSeeds.Factory(), "Combine", new TextureDescription(32, 33, 34, 35, 36, 37), recipe);
        pack.energyConfig = energyConfigDefaultHarvester;
        return pack;
    }

    public static MachinePackage getRubberHarvesterPackage() {
        CraftingIngredients recipe = null;
        MachinePackage pack = new MachinePackage((MachineFactory)new HarvesterRubber.Factory(), "Rubber Harvester", new TextureDescription(64, 65, 66, 67, 68, 69), recipe);
        pack.energyConfig = energyConfigDefaultHarvester;
        return pack;
    }

    public static MachinePackage getPumpkinHarvesterPackage() {
        CraftingIngredients recipe = null;
        if (Config.craftingFarmsEnabled) {
            recipe = new CraftingIngredients(1, new Object[]{"Z#X", "#Y#", "X#Z", Character.valueOf('#'), pb.M, Character.valueOf('X'), pb.ba, Character.valueOf('Z'), pb.br, Character.valueOf('Y'), new aan(ForestryBlock.harvester, 1, 0)});
        }
        MachinePackage pack = new MachinePackage((MachineFactory)new HarvesterHerbaceous.Factory(), "Pumpkin Harvester", new TextureDescription(80, 81, 82, 83, 84, 85), recipe);
        pack.energyConfig = energyConfigDefaultHarvester;
        return pack;
    }

    public static MachinePackage getTurbaryPackage() {
        CraftingIngredients recipe = null;
        if (Config.craftingFarmsEnabled) {
            recipe = new CraftingIngredients(1, new Object[]{"#X#", "XYX", "#Z#", Character.valueOf('#'), pb.M, Character.valueOf('X'), new aan(ForestryItem.tubes, 1, 1), Character.valueOf('Y'), ForestryItem.sturdyMachine, Character.valueOf('Z'), new aan(ForestryItem.circuitboards, 1, 0)});
        }
        MachinePackage pack = new MachinePackage((MachineFactory)new HarvesterPeat.Factory(), "Turbary", new TextureDescription(16, 17, 18, 19, 20, 21), recipe);
        pack.energyConfig = energyConfigDefaultHarvester;
        return pack;
    }

    public static MachinePackage getCactiHarvesterPackage() {
        CraftingIngredients recipe = null;
        if (Config.craftingFarmsEnabled) {
            recipe = new CraftingIngredients(1, new Object[]{"X#X", "#Y#", "X#X", Character.valueOf('#'), pb.M, Character.valueOf('X'), pb.aV, Character.valueOf('Y'), new aan(ForestryBlock.harvester, 1, 0)});
        }
        MachinePackage pack = new MachinePackage((MachineFactory)new HarvesterCacti.Factory(), "Cacti Harvester", new TextureDescription(112, 113, 114, 115, 116, 117), recipe);
        pack.energyConfig = energyConfigDefaultHarvester;
        return pack;
    }

    public static MachinePackage getMushroomPickerPackage() {
        CraftingIngredients recipe = null;
        if (Config.craftingFarmsEnabled) {
            recipe = new CraftingIngredients(1, new Object[]{"X#Z", "#Y#", "Z#X", Character.valueOf('#'), pb.M, Character.valueOf('X'), pb.af, Character.valueOf('Z'), pb.ag, Character.valueOf('Y'), new aan(ForestryBlock.harvester, 1, 0)});
        }
        MachinePackage pack = new MachinePackage((MachineFactory)new HarvesterMushroom.Factory(), "Mushroom Picker", new TextureDescription(128, 129, 130, 131, 132, 133), recipe);
        pack.energyConfig = energyConfigDefaultHarvester;
        return pack;
    }

    public static MachinePackage getReedHarvesterPackage() {
        CraftingIngredients recipe = null;
        if (Config.craftingFarmsEnabled) {
            recipe = new CraftingIngredients(1, new Object[]{"X#X", "#Y#", "X#X", Character.valueOf('#'), pb.M, Character.valueOf('X'), yr.aJ, Character.valueOf('Y'), new aan(ForestryBlock.harvester, 1, 0)});
        }
        MachinePackage pack = new MachinePackage((MachineFactory)new HarvesterReeds.Factory(), "Sugar Cane Harvester", new TextureDescription(144, 145, 146, 147, 148, 149), recipe);
        pack.energyConfig = energyConfigDefaultHarvester;
        return pack;
    }

    public static MachinePackage getNetherCombinePackage() {
        CraftingIngredients recipe = null;
        if (Config.craftingFarmsEnabled) {
            recipe = new CraftingIngredients(1, new Object[]{"X#X", "#Y#", "X#X", Character.valueOf('#'), pb.M, Character.valueOf('X'), yr.br, Character.valueOf('Y'), new aan(ForestryBlock.harvester, 1, 0)});
        }
        MachinePackage pack = new MachinePackage((MachineFactory)new HarvesterNetherwart.Factory(), "Infernal Combine", new TextureDescription(160, 161, 162, 163, 164, 165), recipe);
        pack.energyConfig = energyConfigDefaultHarvester;
        return pack;
    }

    public static MachinePackage getForesterPackage() {
        CraftingIngredients[] recipes = new CraftingIngredients[2];
        recipes[0] = new CraftingIngredients(1, new Object[]{"X#X", "#Y#", "X#X", Character.valueOf('#'), pb.M, Character.valueOf('X'), yr.n, Character.valueOf('Y'), ForestryBlock.planter});
        MachinePackage pack = new MachinePackage((MachineFactory)new MillForester.Factory(), "Forester", RenderProxy.getRenderMill("/gfx/forestry/blocks/forester_"), recipes);
        pack.energyConfig = energyConfigDefaultGrower;
        return pack;
    }

    public static MachinePackage getTreetapPackage() {
        CraftingIngredients recipe = null;
        if (PluginIC2.instance.isAvailable()) {
            recipe = new CraftingIngredients(1, new Object[]{"X#X", "#Y#", "X#X", Character.valueOf('#'), pb.M, Character.valueOf('X'), PluginIC2.treetap, Character.valueOf('Y'), ForestryItem.sturdyMachine});
        }
        byte charges = 8;
        MachinePackage pack = new MachinePackage((MachineFactory)new MillTreetap.Factory(), "Treetap", RenderProxy.getRenderMill("/gfx/forestry/blocks/treetap_", charges), recipe);
        pack.energyConfig = energyConfigDefaultGrower;
        return pack;
    }
}

