/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy;

import forestry.core.gadgets.Engine;
import forestry.core.gadgets.TileForestry;
import forestry.core.gui.ContainerForestry;
import forestry.core.gui.GuiForestry;
import forestry.core.utils.StringUtil;

public abstract class GuiEngine
extends GuiForestry {
    public GuiEngine(String texture, ContainerForestry container, TileForestry tile) {
        super(texture, container, tile);
    }

    @Override
    protected void initLedgers(io inventory) {
        super.initLedgers(inventory);
        this.ledgerManager.insert(new EngineLedger((Engine)this.tile.getMachine()));
    }

    protected class EngineLedger
    extends GuiForestry.Ledger {
        private Engine engine;

        public EngineLedger(Engine engine) {
            this.engine = engine;
            this.maxHeight = 94;
            this.overlayColor = GuiEngine.this.fontColor.get("ledger.power.background");
        }

        @Override
        public void draw(int x, int y) {
            this.drawBackground(x, y);
            this.drawIcon("/gfx/forestry/gui/misc.png", 0, x + 3, y + 4);
            if (!this.isFullyOpened()) {
                return;
            }
            GuiEngine.this.u.a(StringUtil.localize("gui.energy"), x + 22, y + 8, GuiEngine.this.fontColor.get("ledger.power.header"));
            GuiEngine.this.u.a(StringUtil.localize("gui.currentOutput") + ":", x + 22, y + 20, GuiEngine.this.fontColor.get("ledger.power.subheader"));
            GuiEngine.this.u.b(this.engine.getCurrentOutput() + " MJ/t", x + 22, y + 32, GuiEngine.this.fontColor.get("ledger.power.text"));
            GuiEngine.this.u.a(StringUtil.localize("gui.stored") + ":", x + 22, y + 44, GuiEngine.this.fontColor.get("ledger.power.subheader"));
            GuiEngine.this.u.b(this.engine.getEnergyStored() + " MJ", x + 22, y + 56, GuiEngine.this.fontColor.get("ledger.power.text"));
            GuiEngine.this.u.a(StringUtil.localize("gui.heat") + ":", x + 22, y + 68, GuiEngine.this.fontColor.get("ledger.power.subheader"));
            GuiEngine.this.u.b((double)this.engine.getHeat() / 10.0 + " \u00b0C", x + 22, y + 80, GuiEngine.this.fontColor.get("ledger.power.text"));
        }

        @Override
        public String getTooltip() {
            return this.engine.getCurrentOutput() + " MJ/t";
        }
    }
}

