/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy;

import forestry.api.core.ForestryAPI;
import forestry.api.fuels.GeneratorFuel;
import forestry.api.liquids.LiquidContainer;
import forestry.api.liquids.LiquidManager;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.TileMachine;
import forestry.core.network.EntityNetData;
import forestry.core.network.GuiId;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.Orientations;
import forestry.core.utils.StringUtil;
import forestry.core.utils.TankSlot;
import forestry.plugins.PluginIC2;
import ic2.api.Direction;
import ic2.api.EnergyNet;
import ic2.api.IEnergySource;

public class MachineGenerator
extends Machine {
    public static final short SLOT_CAN = 0;
    @EntityNetData
    public TankSlot resourceTank = new TankSlot(10000);
    public int energyStored;
    public int energyMax;
    public boolean isAddedToEnergyNet;
    private int tickCount = 0;
    aan[] inventoryStacks = new aan[1];

    public MachineGenerator(TileMachine tile) {
        super(tile);
        this.setHints((String[])Config.hints.get("generator"));
        this.energyMax = 30000;
    }

    @Override
    public String getName() {
        return StringUtil.localize("tile.machine.4");
    }

    @Override
    public void openGui(yw player, io tile) {
        player.openGui((BaseMod)ForestryAPI.instance, GuiId.GeneratorGUI.ordinal(), player.k, this.tile.j, this.tile.k, this.tile.l);
    }

    @Override
    public void writeToNBT(ady nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("EnergyStored", this.energyStored);
        nbttagcompound.a("EnergyMax", this.energyMax);
        nbttagcompound.a("IsAddedToEnergyNet", this.isAddedToEnergyNet);
        ady NBTresourceSlot = new ady();
        this.resourceTank.writeToNBT(NBTresourceSlot);
        nbttagcompound.a("ResourceTank", (gh)NBTresourceSlot);
        no nbttaglist = new no();
        for (int i = 0; i < this.inventoryStacks.length; ++i) {
            if (this.inventoryStacks[i] == null) continue;
            ady nbttagcompound1 = new ady();
            nbttagcompound1.a("Slot", (byte)i);
            this.inventoryStacks[i].b(nbttagcompound1);
            nbttaglist.a((gh)nbttagcompound1);
        }
        nbttagcompound.a("Items", (gh)nbttaglist);
    }

    @Override
    public void readFromNBT(ady nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.energyStored = nbttagcompound.f("EnergyStored");
        this.energyMax = nbttagcompound.f("EnergyMax");
        this.isAddedToEnergyNet = nbttagcompound.o("IsAddedToEnergyNet");
        this.resourceTank = new TankSlot(10000);
        if (nbttagcompound.c("ResourceTank")) {
            this.resourceTank.readFromNBT(nbttagcompound.m("ResourceTank"));
        }
        no nbttaglist = nbttagcompound.n("Items");
        this.inventoryStacks = new aan[this.a()];
        for (int i = 0; i < nbttaglist.d(); ++i) {
            ady nbttagcompound1 = (ady)nbttaglist.a(i);
            byte byte0 = nbttagcompound1.d("Slot");
            if (byte0 < 0 || byte0 >= this.inventoryStacks.length) continue;
            this.inventoryStacks[byte0] = aan.a((ady)nbttagcompound1);
        }
    }

    @Override
    public void updateServerSide() {
        LiquidContainer container;
        if (!PluginIC2.instance.isAvailable()) {
            this.setErrorState(EnumErrorCode.NOENERGYNET);
            return;
        }
        if (!this.isAddedToEnergyNet) {
            EnergyNet.getForWorld(this.tile.i).addTileEntity(this.tile);
            this.isAddedToEnergyNet = true;
        }
        if (this.resourceTank.quantity > 0 && this.energyStored <= this.energyMax - 10) {
            if (GeneratorFuel.fuels.containsKey(this.resourceTank.liquidId)) {
                GeneratorFuel fuel = (GeneratorFuel)GeneratorFuel.fuels.get(this.resourceTank.liquidId);
                ++this.tickCount;
                if (this.tickCount >= fuel.rate) {
                    this.tickCount = 0;
                    this.energyStored += EnergyNet.getForWorld(this.tile.i).emitEnergyFrom((IEnergySource)((Object)this.tile), fuel.eu);
                    this.resourceTank.empty(fuel.fuelConsumed.liquidAmount, true);
                }
            }
        } else if (this.energyStored > 0) {
            int emit;
            if (this.energyStored >= 32) {
                emit = 32;
                this.energyStored -= 32;
            } else {
                emit = this.energyStored;
                this.energyStored = 0;
            }
            this.energyStored += EnergyNet.getForWorld(this.tile.i).emitEnergyFrom((IEnergySource)((Object)this.tile), emit);
        }
        if (this.resourceTank.quantity <= 0) {
            this.setErrorState(EnumErrorCode.NOFUEL);
        } else {
            this.setErrorState(EnumErrorCode.OK);
        }
        if (this.inventoryStacks[0] != null && (container = LiquidManager.getLiquidContainer(this.inventoryStacks[0])) != null && (container.liquid.isLiquidEqual(new aan(ForestryItem.liquidBiomass)) || container.liquid.isLiquidEqual(new aan(ForestryItem.liquidBiofuel)))) {
            this.inventoryStacks[0] = this.replenishByContainer(this.inventoryStacks[0], container, this.resourceTank);
            if (this.inventoryStacks[0].a <= 0) {
                this.inventoryStacks[0] = null;
            }
        }
    }

    @Override
    public boolean doWork() {
        return false;
    }

    @Override
    public boolean isWorking() {
        return this.resourceTank.quantity > 0;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.quantity * i / 10000;
    }

    public int getStoredScaled(int i) {
        return this.energyStored * i / this.energyMax;
    }

    @Override
    public EnumTankLevel getPrimaryLevel() {
        return this.rateTankLevel(this.getResourceScaled(100));
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.resourceTank.liquidId = j;
                break;
            }
            case 1: {
                this.resourceTank.quantity = j;
                break;
            }
            case 2: {
                this.energyStored = j;
                break;
            }
            case 3: {
                this.energyMax = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(dd container, wm iCrafting) {
        iCrafting.a(container, 0, this.resourceTank.liquidId);
        iCrafting.a(container, 1, this.resourceTank.quantity);
        iCrafting.a(container, 2, this.energyStored);
        iCrafting.a(container, 3, this.energyMax);
    }

    @Override
    public int a() {
        return this.inventoryStacks.length;
    }

    @Override
    public aan k_(int i) {
        return this.inventoryStacks[i];
    }

    @Override
    public aan a(int i, int j) {
        if (this.inventoryStacks[i] == null) {
            return null;
        }
        if (this.inventoryStacks[i].a <= j) {
            aan var3 = this.inventoryStacks[i];
            this.inventoryStacks[i] = null;
            return var3;
        }
        aan var3 = this.inventoryStacks[i].a(j);
        if (this.inventoryStacks[i].a == 0) {
            this.inventoryStacks[i] = null;
        }
        return var3;
    }

    @Override
    public void a(int i, aan itemstack) {
        this.inventoryStacks[i] = itemstack;
        if (itemstack != null && itemstack.a > this.d()) {
            itemstack.a = this.d();
        }
    }

    @Override
    public aan b(int slot) {
        if (this.inventoryStacks[slot] == null) {
            return null;
        }
        aan toReturn = this.inventoryStacks[slot];
        this.inventoryStacks[slot] = null;
        return toReturn;
    }

    @Override
    public int getStartInventorySide(int side) {
        return 0;
    }

    @Override
    public int getSizeInventorySide(int side) {
        return this.inventoryStacks.length;
    }

    @Override
    public boolean addItem(aan stack, boolean doAdd, Orientations from) {
        LiquidContainer container = LiquidManager.getLiquidContainer(stack);
        if (container == null) {
            return false;
        }
        if (container.liquid.itemID != ForestryItem.liquidBiofuel.bQ && container.liquid.itemID != ForestryItem.liquidBiomass.bQ) {
            return false;
        }
        if (this.inventoryStacks[0] == null) {
            if (doAdd) {
                this.inventoryStacks[0] = stack.k();
                stack.a = 0;
            }
            return true;
        }
        if (!this.inventoryStacks[0].a(stack)) {
            return false;
        }
        int space = this.inventoryStacks[0].c() - this.inventoryStacks[0].a;
        if (space <= 0) {
            return false;
        }
        if (doAdd) {
            this.inventoryStacks[0].a += stack.a;
            stack.a -= space;
            if (stack.a < 0) {
                stack.a = 0;
            }
        }
        return true;
    }

    @Override
    public int fill(Orientations from, int quantity, int id, boolean doFill) {
        if (id != ForestryItem.liquidBiomass.bQ && id != ForestryItem.liquidBiofuel.bQ) {
            return 0;
        }
        int used = this.resourceTank.fill(from, quantity, id, doFill);
        if (doFill && used > 0) {
            this.tile.sendNetworkUpdate();
        }
        return used;
    }

    @Override
    public int getCapacity() {
        return 10000;
    }

    @Override
    public TankSlot[] getLiquidContents() {
        return new TankSlot[]{this.resourceTank};
    }

    @Override
    public int getLiquidQuantity() {
        return this.resourceTank.quantity;
    }

    @Override
    public int getLiquidId() {
        return this.resourceTank.liquidId;
    }

    @Override
    public boolean emitsEnergyTo(kw receiver, Direction direction) {
        return true;
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.isAddedToEnergyNet;
    }

    @Override
    public int getMaxEnergyOutput() {
        return 20;
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(kw tile) {
            return new MachineGenerator((TileMachine)tile);
        }
    }
}

