/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory;

import forestry.api.core.EnumHumidity;
import forestry.api.core.ForestryAPI;
import forestry.api.liquids.LiquidContainer;
import forestry.api.liquids.LiquidManager;
import forestry.api.liquids.LiquidStack;
import forestry.core.EnumErrorCode;
import forestry.core.Proxy;
import forestry.core.config.Config;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.TileMachine;
import forestry.core.genetics.ClimateHelper;
import forestry.core.network.EntityNetData;
import forestry.core.network.GuiId;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.Orientations;
import forestry.core.utils.StringUtil;
import forestry.core.utils.TankSlot;
import java.util.LinkedList;

public class MachineRaintank
extends Machine {
    public static final short SLOT_RESOURCE = 0;
    public static final short SLOT_PRODUCT = 1;
    @EntityNetData
    public TankSlot resourceTank = new TankSlot(30000);
    private aan[] inventoryStacks = new aan[3];
    private boolean isValidBiome = true;
    private int fillingTime;
    private int fillingTotalTime;
    private LiquidContainer productPending;
    private aan usedEmpty;

    public MachineRaintank(TileMachine tile) {
        super(tile);
        this.setHints((String[])Config.hints.get("raintank"));
        if (tile.i != null) {
            abn biome = tile.i.a(tile.j, tile.l);
            if (ClimateHelper.getHumidity(biome.G) == EnumHumidity.ARID) {
                this.setErrorState(EnumErrorCode.INVALIDBIOME);
                this.isValidBiome = false;
            }
        }
    }

    @Override
    public String getName() {
        return StringUtil.localize("tile.machine.3");
    }

    @Override
    public void openGui(yw player, io tile) {
        player.openGui((BaseMod)ForestryAPI.instance, GuiId.RaintankGUI.ordinal(), player.k, this.tile.j, this.tile.k, this.tile.l);
    }

    @Override
    public void writeToNBT(ady nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("FillingTime", this.fillingTime);
        nbttagcompound.a("FillingTotalTime", this.fillingTotalTime);
        nbttagcompound.a("IsValidBiome", this.isValidBiome);
        ady NBTresourceSlot = new ady();
        this.resourceTank.writeToNBT(NBTresourceSlot);
        nbttagcompound.a("ResourceTank", (gh)NBTresourceSlot);
        no nbttaglist = new no();
        for (int i = 0; i < this.inventoryStacks.length; ++i) {
            if (this.inventoryStacks[i] == null) continue;
            ady nbttagcompound1 = new ady();
            nbttagcompound1.a("Slot", (byte)i);
            this.inventoryStacks[i].b(nbttagcompound1);
            nbttaglist.a((gh)nbttagcompound1);
        }
        nbttagcompound.a("Items", (gh)nbttaglist);
        if (this.usedEmpty != null) {
            ady nbttagcompoundP = new ady();
            this.usedEmpty.b(nbttagcompoundP);
            nbttagcompound.a("UsedEmpty", (gh)nbttagcompoundP);
        }
    }

    @Override
    public void readFromNBT(ady nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.fillingTime = nbttagcompound.f("FillingTime");
        this.fillingTotalTime = nbttagcompound.f("FillingTotalTime");
        this.isValidBiome = nbttagcompound.o("IsValidBiome");
        this.resourceTank = new TankSlot(30000);
        if (nbttagcompound.c("ResourceTank")) {
            this.resourceTank.readFromNBT(nbttagcompound.m("ResourceTank"));
        }
        no nbttaglist = nbttagcompound.n("Items");
        this.inventoryStacks = new aan[this.a()];
        for (int i = 0; i < nbttaglist.d(); ++i) {
            ady nbttagcompound1 = (ady)nbttaglist.a(i);
            byte byte0 = nbttagcompound1.d("Slot");
            if (byte0 < 0 || byte0 >= this.inventoryStacks.length) continue;
            this.inventoryStacks[byte0] = aan.a((ady)nbttagcompound1);
        }
        if (nbttagcompound.c("UsedEmpty")) {
            ady nbttagcompoundP = nbttagcompound.m("UsedEmpty");
            this.usedEmpty = aan.a((ady)nbttagcompoundP);
        }
    }

    @Override
    public void updateServerSide() {
        if (Proxy.isMultiplayerWorld()) {
            return;
        }
        if (!this.isValidBiome) {
            this.setErrorState(EnumErrorCode.INVALIDBIOME);
            return;
        }
        if (!this.tile.i.m(this.tile.Coords().x, this.tile.Coords().y, this.tile.Coords().z)) {
            this.setErrorState(EnumErrorCode.NOSKY);
            return;
        }
        if (!this.tile.i.G()) {
            this.setErrorState(EnumErrorCode.NOTRAINING);
            return;
        }
        this.resourceTank.fill(null, 10, pb.B.bO, true);
        this.setErrorState(EnumErrorCode.OK);
    }

    @Override
    public boolean doWork() {
        if (Proxy.isMultiplayerWorld()) {
            return false;
        }
        if (this.productPending != null) {
            if (this.tryProductAdd(this.productPending.filled.k(), true)) {
                this.productPending = null;
                return true;
            }
            return false;
        }
        if (this.fillingTime > 0) {
            LiquidContainer container;
            --this.fillingTime;
            if (this.fillingTime <= 0 && this.usedEmpty != null && (container = LiquidManager.getEmptyContainer(this.usedEmpty, new LiquidStack(pb.B, 1))) != null && !this.tryProductAdd(container.filled.k(), true)) {
                this.productPending = container;
            }
            return true;
        }
        if (this.tryStart()) {
            return true;
        }
        this.usedEmpty = null;
        return false;
    }

    private boolean tryStart() {
        if (this.inventoryStacks[0] == null) {
            return false;
        }
        if (this.inventoryStacks[0].a <= 0) {
            return false;
        }
        LiquidContainer container = LiquidManager.getEmptyContainer(this.inventoryStacks[0], new LiquidStack(pb.B, 1));
        if (container == null) {
            return false;
        }
        if (!this.tryProductAdd(container.filled, false)) {
            return false;
        }
        if (this.resourceTank.quantity < container.liquid.liquidAmount) {
            return false;
        }
        this.resourceTank.quantity -= container.liquid.liquidAmount;
        if (this.resourceTank.quantity < 0) {
            this.resourceTank.quantity = 0;
        }
        this.a(0, 1);
        this.fillingTotalTime = 10;
        this.fillingTime = 10;
        this.usedEmpty = container.empty;
        return true;
    }

    private boolean tryProductAdd(aan product, boolean doAdd) {
        if (product == null) {
            return false;
        }
        if (this.inventoryStacks[1] != null) {
            if (this.inventoryStacks[1].c != product.c) {
                return false;
            }
            if (this.inventoryStacks[1].a >= this.inventoryStacks[1].c()) {
                return false;
            }
        }
        if (!doAdd) {
            return true;
        }
        if (this.inventoryStacks[1] == null) {
            this.inventoryStacks[1] = product;
        } else {
            this.inventoryStacks[1].a += product.a;
        }
        return true;
    }

    @Override
    public boolean isWorking() {
        return this.fillingTime > 0;
    }

    @Override
    public boolean hasResourcesMin(float percentage) {
        if (this.inventoryStacks[0] == null) {
            return false;
        }
        return (float)this.inventoryStacks[0].a / (float)this.inventoryStacks[0].c() > percentage;
    }

    @Override
    public boolean hasWork() {
        if (this.fillingTime > 0) {
            return true;
        }
        if (this.inventoryStacks[0] == null) {
            return false;
        }
        LiquidContainer container = LiquidManager.getEmptyContainer(this.inventoryStacks[0], new LiquidStack(pb.B, 1));
        if (container == null) {
            return false;
        }
        return this.resourceTank.quantity >= container.liquid.liquidAmount;
    }

    public int getFillProgressScaled(int i) {
        if (this.fillingTotalTime == 0) {
            return 0;
        }
        return this.fillingTime * i / this.fillingTotalTime;
    }

    @Override
    public EnumTankLevel getPrimaryLevel() {
        return this.rateTankLevel(this.getResourceScaled(100));
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.quantity * i / 30000;
    }

    @Override
    public boolean addItem(aan stack, boolean doAdd, Orientations from) {
        LiquidContainer container = LiquidManager.getEmptyContainer(stack, new LiquidStack(pb.B, 1));
        if (container == null) {
            return false;
        }
        if (this.inventoryStacks[0] == null) {
            if (doAdd) {
                this.inventoryStacks[0] = stack.k();
                stack.a = 0;
            }
            return true;
        }
        if (this.inventoryStacks[0].a >= this.inventoryStacks[0].c()) {
            return false;
        }
        if (!this.inventoryStacks[0].a(stack)) {
            return false;
        }
        int space = this.d() - this.inventoryStacks[0].a;
        if (space >= stack.a) {
            if (doAdd) {
                this.inventoryStacks[0].a += stack.a;
                stack.a = 0;
            }
            return true;
        }
        if (doAdd) {
            this.inventoryStacks[0].a = this.d();
            stack.a -= space;
        }
        return true;
    }

    @Override
    public aan extractItem(boolean doRemove, Orientations from) {
        if (this.inventoryStacks[1] == null) {
            return null;
        }
        if (this.inventoryStacks[1].a <= 0) {
            return null;
        }
        aan product = new aan(this.inventoryStacks[1].a(), 1);
        if (doRemove) {
            --this.inventoryStacks[1].a;
            if (this.inventoryStacks[1].a <= 0) {
                this.inventoryStacks[1] = null;
            }
        }
        return product;
    }

    @Override
    public int a() {
        return this.inventoryStacks.length;
    }

    @Override
    public aan k_(int i) {
        return this.inventoryStacks[i];
    }

    @Override
    public aan a(int i, int j) {
        if (this.inventoryStacks[i] == null) {
            return null;
        }
        if (this.inventoryStacks[i].a <= j) {
            aan removed = this.inventoryStacks[i];
            this.inventoryStacks[i] = null;
            return removed;
        }
        aan removed = this.inventoryStacks[i].a(j);
        if (this.inventoryStacks[i].a == 0) {
            this.inventoryStacks[i] = null;
        }
        return removed;
    }

    @Override
    public void a(int i, aan itemstack) {
        this.inventoryStacks[i] = itemstack;
        if (itemstack != null && itemstack.a > this.d()) {
            itemstack.a = this.d();
        }
    }

    @Override
    public aan b(int slot) {
        if (this.inventoryStacks[slot] == null) {
            return null;
        }
        aan toReturn = this.inventoryStacks[slot];
        this.inventoryStacks[slot] = null;
        return toReturn;
    }

    @Override
    public int getStartInventorySide(int side) {
        if (side == 0 || side == 1) {
            return 0;
        }
        return 1;
    }

    @Override
    public int getSizeInventorySide(int side) {
        return 1;
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.fillingTime = j;
                break;
            }
            case 1: {
                this.fillingTotalTime = j;
                break;
            }
            case 2: {
                this.resourceTank.liquidId = j;
                break;
            }
            case 3: {
                this.resourceTank.quantity = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(dd container, wm iCrafting) {
        iCrafting.a(container, 0, this.fillingTime);
        iCrafting.a(container, 1, this.fillingTotalTime);
        iCrafting.a(container, 2, this.resourceTank.liquidId);
        iCrafting.a(container, 3, this.resourceTank.quantity);
    }

    @Override
    public int fill(Orientations from, int quantity, int id, boolean doFill) {
        if (id != pb.B.bO) {
            return 0;
        }
        int used = this.resourceTank.fill(from, quantity, id, doFill);
        if (doFill && used > 0) {
            this.tile.sendNetworkUpdate();
        }
        return used;
    }

    @Override
    public int empty(int quantityMax, boolean doEmpty) {
        int product = 0;
        if (this.resourceTank.quantity >= quantityMax) {
            product = quantityMax;
            if (doEmpty) {
                this.resourceTank.quantity -= quantityMax;
            }
        } else {
            product = this.resourceTank.quantity;
            if (doEmpty) {
                this.resourceTank.quantity = 0;
            }
        }
        if (doEmpty && product > 0) {
            this.tile.sendNetworkUpdate();
        }
        return product;
    }

    @Override
    public int getLiquidQuantity() {
        return this.resourceTank.quantity;
    }

    @Override
    public int getCapacity() {
        return 30000;
    }

    @Override
    public TankSlot[] getLiquidContents() {
        return new TankSlot[]{this.resourceTank};
    }

    @Override
    public int getLiquidId() {
        return this.resourceTank.liquidId;
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.lowResource25);
        res.add(ForestryTrigger.lowResource10);
        res.add(ForestryTrigger.hasWork);
        return res;
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(kw tile) {
            return new MachineRaintank((TileMachine)tile);
        }
    }
}

