package immibis.core.covers;

import org.lwjgl.opengl.GL11;

import immibis.core.Side;
import net.minecraft.src.forge.MinecraftForgeClient;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.RenderGlobal;
import net.minecraft.src.Tessellator;
import net.minecraft.src.TileEntity;

public class CoversNonSharedProxy {
	private static double u, v;
	private static int[] textures;
	private static double size;
	private static void setTex(int tex)
	{
		u = (tex % 16) / 16.0;
		v = ((tex / 16) + 1) / 16.0;
	}
	
	private static void vertXY(Tessellator t, double x, double y, double z) {	
		t.addVertexWithUV(x, y, z, u+x/16.0, v-y/16.0);
	}
	
	private static void vertXZ(Tessellator t, double x, double y, double z) {	
		t.addVertexWithUV(x, y, z, u+x/16.0, v-z/16.0);
	}
	
	private static void vertYZ(Tessellator t, double x, double y, double z) {	
		t.addVertexWithUV(x, y, z, u+z/16.0, v-y/16.0);
	}
	
	private static final double HOLLOW_EDGE_SIZE = 0.25;
	
	private static void renderHollowPanelYZ(Tessellator t, AxisAlignedBB aabb) {
		setTex(textures[Side.NX]);
		t.setNormal(-1, 0, 0);
		
		vertYZ(t, aabb.minX, 0+HOLLOW_EDGE_SIZE, HOLLOW_EDGE_SIZE);
		vertYZ(t, aabb.minX, 1-HOLLOW_EDGE_SIZE, HOLLOW_EDGE_SIZE);
		vertYZ(t, aabb.minX, 1, 0);
		vertYZ(t, aabb.minX, 0, 0);
		
		vertYZ(t, aabb.minX, 0, 1);
		vertYZ(t, aabb.minX, 1, 1);
		vertYZ(t, aabb.minX, 1-HOLLOW_EDGE_SIZE, 1-HOLLOW_EDGE_SIZE);
		vertYZ(t, aabb.minX, HOLLOW_EDGE_SIZE, 1-HOLLOW_EDGE_SIZE);
		
		vertYZ(t, aabb.minX, 0, 1);
		vertYZ(t, aabb.minX, HOLLOW_EDGE_SIZE, 1-HOLLOW_EDGE_SIZE);
		vertYZ(t, aabb.minX, HOLLOW_EDGE_SIZE, HOLLOW_EDGE_SIZE);
		vertYZ(t, aabb.minX, 0, 0);
		
		vertYZ(t, aabb.minX, 1, 0);
		vertYZ(t, aabb.minX, 1-HOLLOW_EDGE_SIZE, HOLLOW_EDGE_SIZE);
		vertYZ(t, aabb.minX, 1-HOLLOW_EDGE_SIZE, 1-HOLLOW_EDGE_SIZE);
		vertYZ(t, aabb.minX, 1, 1);
		
		setTex(textures[Side.PX]);
		t.setNormal(1, 0, 0);
		
		vertYZ(t, aabb.maxX, 0, 0);
		vertYZ(t, aabb.maxX, 1, 0);
		vertYZ(t, aabb.maxX, 1-HOLLOW_EDGE_SIZE, HOLLOW_EDGE_SIZE);
		vertYZ(t, aabb.maxX, HOLLOW_EDGE_SIZE, HOLLOW_EDGE_SIZE);
		
		vertYZ(t, aabb.maxX, HOLLOW_EDGE_SIZE, 1-HOLLOW_EDGE_SIZE);
		vertYZ(t, aabb.maxX, 1-HOLLOW_EDGE_SIZE, 1-HOLLOW_EDGE_SIZE);
		vertYZ(t, aabb.maxX, 1, 1);
		vertYZ(t, aabb.maxX, 0, 1);
		
		vertYZ(t, aabb.maxX, 0, 0);
		vertYZ(t, aabb.maxX, HOLLOW_EDGE_SIZE, 0+HOLLOW_EDGE_SIZE);
		vertYZ(t, aabb.maxX, HOLLOW_EDGE_SIZE, 1-HOLLOW_EDGE_SIZE);
		vertYZ(t, aabb.maxX, 0, 1);
		
		vertYZ(t, aabb.maxX, 1, 1);
		vertYZ(t, aabb.maxX, 1-HOLLOW_EDGE_SIZE, 1-HOLLOW_EDGE_SIZE);
		vertYZ(t, aabb.maxX, 1-HOLLOW_EDGE_SIZE, HOLLOW_EDGE_SIZE);
		vertYZ(t, aabb.maxX, 1, 0);
		
		setTex(textures[Side.NY]);
		t.setNormal(0, -1, 0);
		vertXZ(t, aabb.minX, 0, 0);
		vertXZ(t, aabb.maxX, 0, 0);
		vertXZ(t, aabb.maxX, 0, 1);
		vertXZ(t, aabb.minX, 0, 1);
		
		vertXZ(t, aabb.minX, HOLLOW_EDGE_SIZE, 1-HOLLOW_EDGE_SIZE);
		vertXZ(t, aabb.maxX, HOLLOW_EDGE_SIZE, 1-HOLLOW_EDGE_SIZE);
		vertXZ(t, aabb.maxX, HOLLOW_EDGE_SIZE, HOLLOW_EDGE_SIZE);
		vertXZ(t, aabb.minX, HOLLOW_EDGE_SIZE, HOLLOW_EDGE_SIZE);
		
		setTex(textures[Side.PY]);
		t.setNormal(0, 1, 0);
		vertXZ(t, aabb.minX, 1, 1);
		vertXZ(t, aabb.maxX, 1, 1);
		vertXZ(t, aabb.maxX, 1, 0);
		vertXZ(t, aabb.minX, 1, 0);
		
		vertXZ(t, aabb.minX, 1-HOLLOW_EDGE_SIZE, HOLLOW_EDGE_SIZE);
		vertXZ(t, aabb.maxX, 1-HOLLOW_EDGE_SIZE, HOLLOW_EDGE_SIZE);
		vertXZ(t, aabb.maxX, 1-HOLLOW_EDGE_SIZE, 1-HOLLOW_EDGE_SIZE);
		vertXZ(t, aabb.minX, 1-HOLLOW_EDGE_SIZE, 1-HOLLOW_EDGE_SIZE);
		
		setTex(textures[Side.NZ]);
		t.setNormal(0, 0, -1);
		vertXY(t, aabb.minX, 0, 0);
		vertXY(t, aabb.minX, 1, 0);
		vertXY(t, aabb.maxX, 1, 0);
		vertXY(t, aabb.maxX, 0, 0);
		
		vertXY(t, aabb.minX, 1-HOLLOW_EDGE_SIZE, HOLLOW_EDGE_SIZE);
		vertXY(t, aabb.minX, HOLLOW_EDGE_SIZE, HOLLOW_EDGE_SIZE);
		vertXY(t, aabb.maxX, HOLLOW_EDGE_SIZE, HOLLOW_EDGE_SIZE);
		vertXY(t, aabb.maxX, 1-HOLLOW_EDGE_SIZE, HOLLOW_EDGE_SIZE);
		
		setTex(textures[Side.PZ]);
		t.setNormal(0, 0, 1);
		vertXY(t, aabb.minX, 1, 1);
		vertXY(t, aabb.minX, 0, 1);
		vertXY(t, aabb.maxX, 0, 1);
		vertXY(t, aabb.maxX, 1, 1);
		
		vertXY(t, aabb.minX, HOLLOW_EDGE_SIZE, 1-HOLLOW_EDGE_SIZE);
		vertXY(t, aabb.minX, 1-HOLLOW_EDGE_SIZE, 1-HOLLOW_EDGE_SIZE);
		vertXY(t, aabb.maxX, 1-HOLLOW_EDGE_SIZE, 1-HOLLOW_EDGE_SIZE);
		vertXY(t, aabb.maxX, HOLLOW_EDGE_SIZE, 1-HOLLOW_EDGE_SIZE);
	}
	
	private static void renderHollowPanelXZ(Tessellator t, AxisAlignedBB aabb) {
		setTex(textures[Side.NY]);
		t.setNormal(0, -1, 0);
		vertXZ(t, HOLLOW_EDGE_SIZE, aabb.minY, HOLLOW_EDGE_SIZE);
		vertXZ(t, HOLLOW_EDGE_SIZE, aabb.minY, 1-HOLLOW_EDGE_SIZE);
		vertXZ(t, 0, aabb.minY, 1);
		vertXZ(t, 0, aabb.minY, 0);
		
		vertXZ(t, 1-HOLLOW_EDGE_SIZE, aabb.minY, 1-HOLLOW_EDGE_SIZE);
		vertXZ(t, 1-HOLLOW_EDGE_SIZE, aabb.minY, HOLLOW_EDGE_SIZE);
		vertXZ(t, 1, aabb.minY, 0);
		vertXZ(t, 1, aabb.minY, 1);
		
		vertXZ(t, 0, aabb.minY, 0);
		vertXZ(t, 1, aabb.minY, 0);
		vertXZ(t, 1-HOLLOW_EDGE_SIZE, aabb.minY, HOLLOW_EDGE_SIZE);
		vertXZ(t, HOLLOW_EDGE_SIZE, aabb.minY, HOLLOW_EDGE_SIZE);
		
		vertXZ(t, HOLLOW_EDGE_SIZE, aabb.minY, 1-HOLLOW_EDGE_SIZE);
		vertXZ(t, 1-HOLLOW_EDGE_SIZE, aabb.minY, 1-HOLLOW_EDGE_SIZE);
		vertXZ(t, 1, aabb.minY, 1);
		vertXZ(t, 0, aabb.minY, 1);
		
		setTex(textures[Side.PY]);
		t.setNormal(0, 1, 0);
		vertXZ(t, 0, aabb.maxY, 0);
		vertXZ(t, 0, aabb.maxY, 1);
		vertXZ(t, HOLLOW_EDGE_SIZE, aabb.maxY, 1-HOLLOW_EDGE_SIZE);
		vertXZ(t, HOLLOW_EDGE_SIZE, aabb.maxY, HOLLOW_EDGE_SIZE);
		
		vertXZ(t, 1, aabb.maxY, 1);
		vertXZ(t, 1, aabb.maxY, 0);
		vertXZ(t, 1-HOLLOW_EDGE_SIZE, aabb.maxY, HOLLOW_EDGE_SIZE);
		vertXZ(t, 1-HOLLOW_EDGE_SIZE, aabb.maxY, 1-HOLLOW_EDGE_SIZE);
		
		vertXZ(t, HOLLOW_EDGE_SIZE, aabb.maxY, HOLLOW_EDGE_SIZE);
		vertXZ(t, 1-HOLLOW_EDGE_SIZE, aabb.maxY, HOLLOW_EDGE_SIZE);
		vertXZ(t, 1, aabb.maxY, 0);
		vertXZ(t, 0, aabb.maxY, 0);
		
		vertXZ(t, 0, aabb.maxY, 1);
		vertXZ(t, 1, aabb.maxY, 1);
		vertXZ(t, 1-HOLLOW_EDGE_SIZE, aabb.maxY, 1-HOLLOW_EDGE_SIZE);
		vertXZ(t, HOLLOW_EDGE_SIZE, aabb.maxY, 1-HOLLOW_EDGE_SIZE);
		
		setTex(textures[Side.NX]);
		t.setNormal(-1, 0, 0);
		vertYZ(t, 0, aabb.minY, 0);
		vertYZ(t, 0, aabb.minY, 1);
		vertYZ(t, 0, aabb.maxY, 1);
		vertYZ(t, 0, aabb.maxY, 0);
		
		vertYZ(t, HOLLOW_EDGE_SIZE, aabb.minY, 1-HOLLOW_EDGE_SIZE);
		vertYZ(t, HOLLOW_EDGE_SIZE, aabb.minY, HOLLOW_EDGE_SIZE);
		vertYZ(t, HOLLOW_EDGE_SIZE, aabb.maxY, HOLLOW_EDGE_SIZE);
		vertYZ(t, HOLLOW_EDGE_SIZE, aabb.maxY, 1-HOLLOW_EDGE_SIZE);
		
		setTex(textures[Side.PX]);
		t.setNormal(1, 0, 0);
		vertYZ(t, 1, aabb.minY, 1);
		vertYZ(t, 1, aabb.minY, 0);
		vertYZ(t, 1, aabb.maxY, 0);
		vertYZ(t, 1, aabb.maxY, 1);
		
		vertYZ(t, 1-HOLLOW_EDGE_SIZE, aabb.maxY, 1-HOLLOW_EDGE_SIZE);
		vertYZ(t, 1-HOLLOW_EDGE_SIZE, aabb.maxY, HOLLOW_EDGE_SIZE);
		vertYZ(t, 1-HOLLOW_EDGE_SIZE, aabb.minY, HOLLOW_EDGE_SIZE);
		vertYZ(t, 1-HOLLOW_EDGE_SIZE, aabb.minY, 1-HOLLOW_EDGE_SIZE);
		
		setTex(textures[Side.NZ]);
		t.setNormal(0, 0, -1);
		vertXY(t, 0, aabb.minY, 0);
		vertXY(t, 0, aabb.maxY, 0);
		vertXY(t, 1, aabb.maxY, 0);
		vertXY(t, 1, aabb.minY, 0);
		
		vertXY(t, 1-HOLLOW_EDGE_SIZE, aabb.minY, HOLLOW_EDGE_SIZE);
		vertXY(t, 1-HOLLOW_EDGE_SIZE, aabb.maxY, HOLLOW_EDGE_SIZE);
		vertXY(t, HOLLOW_EDGE_SIZE, aabb.maxY, HOLLOW_EDGE_SIZE);
		vertXY(t, HOLLOW_EDGE_SIZE, aabb.minY, HOLLOW_EDGE_SIZE);
		
		setTex(textures[Side.PZ]);
		t.setNormal(0, 0, 1);
		vertXY(t, 1, aabb.minY, 1);
		vertXY(t, 1, aabb.maxY, 1);
		vertXY(t, 0, aabb.maxY, 1);
		vertXY(t, 0, aabb.minY, 1);
		
		vertXY(t, HOLLOW_EDGE_SIZE, aabb.minY, 1-HOLLOW_EDGE_SIZE);
		vertXY(t, HOLLOW_EDGE_SIZE, aabb.maxY, 1-HOLLOW_EDGE_SIZE);
		vertXY(t, 1-HOLLOW_EDGE_SIZE, aabb.maxY, 1-HOLLOW_EDGE_SIZE);
		vertXY(t, 1-HOLLOW_EDGE_SIZE, aabb.minY, 1-HOLLOW_EDGE_SIZE);
	}
		
	private static void renderHollowPanelXY(Tessellator t, AxisAlignedBB aabb) {
		setTex(textures[Side.NZ]);
		t.setNormal(0, 0, -1);
		vertXY(t, 0, 0, aabb.minZ);
		vertXY(t, 0, 1, aabb.minZ);
		vertXY(t, HOLLOW_EDGE_SIZE, 1-HOLLOW_EDGE_SIZE, aabb.minZ);
		vertXY(t, HOLLOW_EDGE_SIZE, HOLLOW_EDGE_SIZE, aabb.minZ);
		
		vertXY(t, 1, 1, aabb.minZ);
		vertXY(t, 1, 0, aabb.minZ);
		vertXY(t, 1-HOLLOW_EDGE_SIZE, HOLLOW_EDGE_SIZE, aabb.minZ);
		vertXY(t, 1-HOLLOW_EDGE_SIZE, 1-HOLLOW_EDGE_SIZE, aabb.minZ);
		
		vertXY(t, HOLLOW_EDGE_SIZE, HOLLOW_EDGE_SIZE, aabb.minZ);
		vertXY(t, 1-HOLLOW_EDGE_SIZE, HOLLOW_EDGE_SIZE, aabb.minZ);
		vertXY(t, 1, 0, aabb.minZ);
		vertXY(t, 0, 0, aabb.minZ);
		
		vertXY(t, 0, 1, aabb.minZ);
		vertXY(t, 1, 1, aabb.minZ);
		vertXY(t, 1-HOLLOW_EDGE_SIZE, 1-HOLLOW_EDGE_SIZE, aabb.minZ);
		vertXY(t, HOLLOW_EDGE_SIZE, 1-HOLLOW_EDGE_SIZE, aabb.minZ);
		
		setTex(textures[Side.PZ]);
		t.setNormal(0, 0, 1);
		vertXY(t, HOLLOW_EDGE_SIZE, HOLLOW_EDGE_SIZE, aabb.maxZ);
		vertXY(t, HOLLOW_EDGE_SIZE, 1-HOLLOW_EDGE_SIZE, aabb.maxZ);
		vertXY(t, 0, 1, aabb.maxZ);
		vertXY(t, 0, 0, aabb.maxZ);
		
		vertXY(t, 1-HOLLOW_EDGE_SIZE, 1-HOLLOW_EDGE_SIZE, aabb.maxZ);
		vertXY(t, 1-HOLLOW_EDGE_SIZE, HOLLOW_EDGE_SIZE, aabb.maxZ);
		vertXY(t, 1, 0, aabb.maxZ);
		vertXY(t, 1, 1, aabb.maxZ);
		
		vertXY(t, 0, 0, aabb.maxZ);
		vertXY(t, 1, 0, aabb.maxZ);
		vertXY(t, 1-HOLLOW_EDGE_SIZE, HOLLOW_EDGE_SIZE, aabb.maxZ);
		vertXY(t, HOLLOW_EDGE_SIZE, HOLLOW_EDGE_SIZE, aabb.maxZ);
		
		vertXY(t, HOLLOW_EDGE_SIZE, 1-HOLLOW_EDGE_SIZE, aabb.maxZ);
		vertXY(t, 1-HOLLOW_EDGE_SIZE, 1-HOLLOW_EDGE_SIZE, aabb.maxZ);
		vertXY(t, 1, 1, aabb.maxZ);
		vertXY(t, 0, 1, aabb.maxZ);
		
		setTex(textures[Side.NX]);
		t.setNormal(-1, 0, 0);
		vertYZ(t, 0, 1, aabb.minZ);
		vertYZ(t, 0, 0, aabb.minZ);
		vertYZ(t, 0, 0, aabb.maxZ);
		vertYZ(t, 0, 1, aabb.maxZ);
		
		vertYZ(t, HOLLOW_EDGE_SIZE, HOLLOW_EDGE_SIZE, aabb.minZ);
		vertYZ(t, HOLLOW_EDGE_SIZE, 1-HOLLOW_EDGE_SIZE, aabb.minZ);
		vertYZ(t, HOLLOW_EDGE_SIZE, 1-HOLLOW_EDGE_SIZE, aabb.maxZ);
		vertYZ(t, HOLLOW_EDGE_SIZE, HOLLOW_EDGE_SIZE, aabb.maxZ);
		
		setTex(textures[Side.PX]);
		t.setNormal(1, 0, 0);
		vertYZ(t, 1, 0, aabb.minZ);
		vertYZ(t, 1, 1, aabb.minZ);
		vertYZ(t, 1, 1, aabb.maxZ);
		vertYZ(t, 1, 0, aabb.maxZ);
		
		vertYZ(t, 1-HOLLOW_EDGE_SIZE, HOLLOW_EDGE_SIZE, aabb.maxZ);
		vertYZ(t, 1-HOLLOW_EDGE_SIZE, 1-HOLLOW_EDGE_SIZE, aabb.maxZ);
		vertYZ(t, 1-HOLLOW_EDGE_SIZE, 1-HOLLOW_EDGE_SIZE, aabb.minZ);
		vertYZ(t, 1-HOLLOW_EDGE_SIZE, HOLLOW_EDGE_SIZE, aabb.minZ);
		
		setTex(textures[Side.NY]);
		t.setNormal(0, -1, 0);
		vertXZ(t, 1, 0, aabb.minZ);
		vertXZ(t, 1, 0, aabb.maxZ);
		vertXZ(t, 0, 0, aabb.maxZ);
		vertXZ(t, 0, 0, aabb.minZ);
		
		vertXZ(t, HOLLOW_EDGE_SIZE, HOLLOW_EDGE_SIZE, aabb.minZ);
		vertXZ(t, HOLLOW_EDGE_SIZE, HOLLOW_EDGE_SIZE, aabb.maxZ);
		vertXZ(t, 1-HOLLOW_EDGE_SIZE, HOLLOW_EDGE_SIZE, aabb.maxZ);
		vertXZ(t, 1-HOLLOW_EDGE_SIZE, HOLLOW_EDGE_SIZE, aabb.minZ);
		
		setTex(textures[Side.PY]);
		t.setNormal(0, 1, 0);
		vertXZ(t, 0, 1, aabb.minZ);
		vertXZ(t, 0, 1, aabb.maxZ);
		vertXZ(t, 1, 1, aabb.maxZ);
		vertXZ(t, 1, 1, aabb.minZ);
		
		vertXZ(t, 1-HOLLOW_EDGE_SIZE, 1-HOLLOW_EDGE_SIZE, aabb.minZ);
		vertXZ(t, 1-HOLLOW_EDGE_SIZE, 1-HOLLOW_EDGE_SIZE, aabb.maxZ);
		vertXZ(t, HOLLOW_EDGE_SIZE, 1-HOLLOW_EDGE_SIZE, aabb.maxZ);
		vertXZ(t, HOLLOW_EDGE_SIZE, 1-HOLLOW_EDGE_SIZE, aabb.minZ);
	}
	
	protected static void renderQuads(Tessellator t, EnumPosition pos, PartType pt) {
		AxisAlignedBB aabb = Part.getBoundingBox(pos, size);
		
		int tex;
		double u, v;
		
		if(pt.clazz == EnumPartClass.HollowPanel)
		{
			if(pos.x != EnumAxisPosition.Span)
				renderHollowPanelYZ(t, aabb);
			else if(pos.y != EnumAxisPosition.Span)
				renderHollowPanelXZ(t, aabb);
			else if(pos.z != EnumAxisPosition.Span)
				renderHollowPanelXY(t, aabb);
			return;
		}
		
		renderAABB(t, aabb, textures);
	}
	
	static void renderAABB(Tessellator t, AxisAlignedBB aabb, int[] textures) {
		int tex;
		setTex(textures[Side.NZ]);
		t.setNormal(0, 0, -1);
		vertXY(t, aabb.minX, aabb.minY, aabb.minZ);
		vertXY(t, aabb.minX, aabb.maxY, aabb.minZ);
		vertXY(t, aabb.maxX, aabb.maxY, aabb.minZ);
		vertXY(t, aabb.maxX, aabb.minY, aabb.minZ);
		
		tex = textures[Side.NY]; u = (tex % 16) / 16.0; v = ((tex / 16) + 1) / 16.0;
		t.setNormal(0, -1, 0);
		t.addVertexWithUV(aabb.maxX, aabb.minY, aabb.minZ, u+aabb.maxX/16.0, v-aabb.minZ/16.0);
		t.addVertexWithUV(aabb.maxX, aabb.minY, aabb.maxZ, u+aabb.maxX/16.0, v-aabb.maxZ/16.0);
		t.addVertexWithUV(aabb.minX, aabb.minY, aabb.maxZ, u+aabb.minX/16.0, v-aabb.maxZ/16.0);
		t.addVertexWithUV(aabb.minX, aabb.minY, aabb.minZ, u+aabb.minX/16.0, v-aabb.minZ/16.0);
		
		tex = textures[Side.NX]; u = (tex % 16) / 16.0; v = ((tex / 16) + 1) / 16.0;
		t.setNormal(-1, 0, 0);
		t.addVertexWithUV(aabb.minX, aabb.minY, aabb.minZ, u+aabb.minZ/16.0, v-aabb.minY/16.0);
		t.addVertexWithUV(aabb.minX, aabb.minY, aabb.maxZ, u+aabb.maxZ/16.0, v-aabb.minY/16.0);
		t.addVertexWithUV(aabb.minX, aabb.maxY, aabb.maxZ, u+aabb.maxZ/16.0, v-aabb.maxY/16.0);
		t.addVertexWithUV(aabb.minX, aabb.maxY, aabb.minZ, u+aabb.minZ/16.0, v-aabb.maxY/16.0);
		
		tex = textures[Side.PZ]; u = (tex % 16) / 16.0; v = ((tex / 16) + 1) / 16.0;
		t.setNormal(0, 0, 1);
		t.addVertexWithUV(aabb.maxX, aabb.minY, aabb.maxZ, u+aabb.maxX/16.0, v-aabb.minY/16.0);
		t.addVertexWithUV(aabb.maxX, aabb.maxY, aabb.maxZ, u+aabb.maxX/16.0, v-aabb.maxY/16.0);
		t.addVertexWithUV(aabb.minX, aabb.maxY, aabb.maxZ, u+aabb.minX/16.0, v-aabb.maxY/16.0);
		t.addVertexWithUV(aabb.minX, aabb.minY, aabb.maxZ, u+aabb.minX/16.0, v-aabb.minY/16.0);
		
		tex = textures[Side.PY]; u = (tex % 16) / 16.0; v = ((tex / 16) + 1) / 16.0;
		t.setNormal(0, 1, 0);
		t.addVertexWithUV(aabb.minX, aabb.maxY, aabb.minZ, u+aabb.minX/16.0, v-aabb.minZ/16.0);
		t.addVertexWithUV(aabb.minX, aabb.maxY, aabb.maxZ, u+aabb.minX/16.0, v-aabb.maxZ/16.0);
		t.addVertexWithUV(aabb.maxX, aabb.maxY, aabb.maxZ, u+aabb.maxX/16.0, v-aabb.maxZ/16.0);
		t.addVertexWithUV(aabb.maxX, aabb.maxY, aabb.minZ, u+aabb.maxX/16.0, v-aabb.minZ/16.0);
		
		tex = textures[Side.PX]; u = (tex % 16) / 16.0; v = ((tex / 16) + 1) / 16.0;
		t.setNormal(1, 0, 0);
		t.addVertexWithUV(aabb.maxX, aabb.maxY, aabb.minZ, u+aabb.minZ/16.0, v-aabb.maxY/16.0);
		t.addVertexWithUV(aabb.maxX, aabb.maxY, aabb.maxZ, u+aabb.maxZ/16.0, v-aabb.maxY/16.0);
		t.addVertexWithUV(aabb.maxX, aabb.minY, aabb.maxZ, u+aabb.maxZ/16.0, v-aabb.minY/16.0);
		t.addVertexWithUV(aabb.maxX, aabb.minY, aabb.minZ, u+aabb.minZ/16.0, v-aabb.minY/16.0);
	}
	
	public static void renderPartPreview(RenderGlobal render, EnumPosition pos, PartType p) {
		size = p.size; textures = p.textures;
		GL11.glEnable(GL11.GL_BLEND);
		GL11.glColor4f(1.0f, 1.0f, 1.0f, 0.5f);

		Tessellator t = Tessellator.instance;
		t.startDrawingQuads();
		
		renderQuads(t, pos, p);
		
		t.draw();
		GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
		GL11.glDisable(GL11.GL_BLEND);
	}
	
	public static void renderPartInv(RenderBlocks render, PartType p) {
		size = p.size; textures = p.textures;
		GL11.glEnable(GL11.GL_BLEND);
		GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
		GL11.glPushMatrix();
		
		EnumPosition pos;
		switch(p.clazz)
		{
		case Centre:
			pos = EnumPosition.Centre;
			break;
		case Panel: case HollowPanel:
			pos = EnumPosition.CoverNZ;
			GL11.glTranslatef(0, 0, 0.5f-(float)size/2);
			break;
		case Strip:
			pos = EnumPosition.EdgeNXNZ;
			GL11.glTranslatef(0.5f-(float)size/2, 0, 0.5f-(float)size/2);
			break;
		case Corner:
			pos = EnumPosition.CornerNXNYNZ;
			GL11.glTranslatef(0.5f-(float)size/2, 0.5f-(float)size/2, 0.5f-(float)size/2);
			break;
		default:
			pos = EnumPosition.Centre;
		}
		
		Tessellator t = Tessellator.instance;
		t.startDrawingQuads();
		
		renderQuads(t, pos, p);
		
		t.draw();
		GL11.glPopMatrix();
		GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
		GL11.glDisable(GL11.GL_BLEND);
	}

	public static void renderPartWorld(Part p, RenderBlocks render, int x, int y, int z) {
		BlockMultipart.texindices = p.type.textures;
		size = p.type.size; textures = p.type.textures;
		if(p.type.clazz == EnumPartClass.HollowPanel)
		{
			Block block = CoverSystemProxy.blockMultipart;
			float hes = (float)HOLLOW_EDGE_SIZE;
			float s = (float)size;
			switch(p.pos)
			{
			case CoverNX:
				block.setBlockBounds(0, 0, 0, s, hes, 1);
				render.renderStandardBlock(CoverSystemProxy.blockMultipart, x, y, z);
				block.setBlockBounds(0, 1-hes, 0, s, 1, 1);
				render.renderStandardBlock(CoverSystemProxy.blockMultipart, x, y, z);
				block.setBlockBounds(0, hes, 0, s, 1-hes, hes);
				render.renderStandardBlock(CoverSystemProxy.blockMultipart, x, y, z);
				block.setBlockBounds(0, hes, 1-hes, s, 1-hes, 1);
				render.renderStandardBlock(CoverSystemProxy.blockMultipart, x, y, z);
				break;
			case CoverPX:
				block.setBlockBounds(1-s, 0, 0, 1, hes, 1);
				render.renderStandardBlock(CoverSystemProxy.blockMultipart, x, y, z);
				block.setBlockBounds(1-s, 1-hes, 0, 1, 1, 1);
				render.renderStandardBlock(CoverSystemProxy.blockMultipart, x, y, z);
				block.setBlockBounds(1-s, hes, 0, 1, 1-hes, hes);
				render.renderStandardBlock(CoverSystemProxy.blockMultipart, x, y, z);
				block.setBlockBounds(1-s, hes, 1-hes, 1, 1-hes, 1);
				render.renderStandardBlock(CoverSystemProxy.blockMultipart, x, y, z);
				break;
			case CoverNY:
				block.setBlockBounds(0, 0, 0, hes, s, 1);
				render.renderStandardBlock(CoverSystemProxy.blockMultipart, x, y, z);
				block.setBlockBounds(1-hes, 0, 0, 1, s, 1);
				render.renderStandardBlock(CoverSystemProxy.blockMultipart, x, y, z);
				block.setBlockBounds(hes, 0, 0, 1-hes, s, hes);
				render.renderStandardBlock(CoverSystemProxy.blockMultipart, x, y, z);
				block.setBlockBounds(hes, 0, 1-hes, 1-hes, s, 1);
				render.renderStandardBlock(CoverSystemProxy.blockMultipart, x, y, z);
				break;
			case CoverPY:
				block.setBlockBounds(0, 1-s, 0, hes, 1, 1);
				render.renderStandardBlock(CoverSystemProxy.blockMultipart, x, y, z);
				block.setBlockBounds(1-hes, 1-s, 0, 1, 1, 1);
				render.renderStandardBlock(CoverSystemProxy.blockMultipart, x, y, z);
				block.setBlockBounds(hes, 1-s, 0, 1-hes, 1, hes);
				render.renderStandardBlock(CoverSystemProxy.blockMultipart, x, y, z);
				block.setBlockBounds(hes, 1-s, 1-hes, 1-hes, 1, 1);
				render.renderStandardBlock(CoverSystemProxy.blockMultipart, x, y, z);
				break;
			case CoverNZ:
				block.setBlockBounds(0, 0, 0, hes, 1, s);
				render.renderStandardBlock(CoverSystemProxy.blockMultipart, x, y, z);
				block.setBlockBounds(1-hes, 0, 0, 1, 1, s);
				render.renderStandardBlock(CoverSystemProxy.blockMultipart, x, y, z);
				block.setBlockBounds(hes, 0, 0, 1-hes, hes, s);
				render.renderStandardBlock(CoverSystemProxy.blockMultipart, x, y, z);
				block.setBlockBounds(hes, 1-hes, 0, 1-hes, 1, s);
				render.renderStandardBlock(CoverSystemProxy.blockMultipart, x, y, z);
				break;
			case CoverPZ:
				block.setBlockBounds(0, 0, 1-s, hes, 1, 1);
				render.renderStandardBlock(CoverSystemProxy.blockMultipart, x, y, z);
				block.setBlockBounds(1-hes, 0, 1-s, 1, 1, 1);
				render.renderStandardBlock(CoverSystemProxy.blockMultipart, x, y, z);
				block.setBlockBounds(hes, 0, 1-s, 1-hes, hes, 1);
				render.renderStandardBlock(CoverSystemProxy.blockMultipart, x, y, z);
				block.setBlockBounds(hes, 1-hes, 1-s, 1-hes, 1, 1);
				render.renderStandardBlock(CoverSystemProxy.blockMultipart, x, y, z);
				break;
			}
		}
		else
		{
			CoverSystemProxy.blockMultipart.setAABB(p.getBoundingBox());
			render.renderStandardBlock(CoverSystemProxy.blockMultipart, x, y, z);
		}
	}
	static void RenderCover(CoverImpl cover, RenderBlocks render, int x, int y, int z) {
		String tex = "/terrain.png";
		for(Part p : cover.parts)
		{
			if(!p.type.texfile.equals(tex))
			{
				if(tex != "/terrain.png") // != is ok here
					MinecraftForgeClient.unbindTexture();
				tex = p.type.texfile;
				MinecraftForgeClient.bindTexture(tex);
			}
			renderPartWorld(p, render, x, y, z);
		}
		if(tex != "/terrain.png") // != is ok here
			MinecraftForgeClient.unbindTexture();
		CoverSystemProxy.blockMultipart.setBlockBounds(0, 0, 0, 1, 1, 1);
	}
	
	static void RegisterHighlightHandler() {
		MinecraftForgeClient.registerHighlightHandler(new MultipartHighlightHandler());
	}
	
	static void renderCoverableBase(TileCoverableBase te, RenderBlocks rb) {
		Block block = Block.blocksList[te.worldObj.getBlockId(te.xCoord, te.yCoord, te.zCoord)];
		BlockCoverableBase.useRealRenderType = true;
		if(block instanceof ICoverableTextureProvider)
		{
			String t = ((ICoverableTextureProvider)block).getTextureFile();
			MinecraftForgeClient.bindTexture(t);
			rb.renderBlockByRenderType(block, te.xCoord, te.yCoord, te.zCoord);
			MinecraftForgeClient.unbindTexture();
		}
		else
			rb.renderBlockByRenderType(block, te.xCoord, te.yCoord, te.zCoord);
		BlockCoverableBase.useRealRenderType = false;
	}
	
	public static void RenderWorldBlock(RenderBlocks render, IBlockAccess world, int x, int y, int z, Block block) {
		TileEntity te = world.getBlockTileEntity(x, y, z);
		if(te instanceof ICoverableTile)
			RenderCover(((ICoverableTile)te).getCoverImpl(), render, x, y, z);
		if(te instanceof TileCoverableBase)
			renderCoverableBase((TileCoverableBase)te, render);
	}
	
	public static void RenderInvBlock(RenderBlocks render, Block block, int meta) {
		PartType type = CoverSystemProxy.parts.get(meta);
		if(type == null)
			return;
		
		renderPartInv(render, type);
	}
}
