package net.minecraft.src;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;

import net.minecraft.client.Minecraft;

import immibis.core.*;
import immibis.core.covers.CoverSystemProxy;
import immibis.core.covers.ICoverableTile;
import immibis.core.covers.TileMultipart;

public class mod_ImmibisCore extends CompatibleBaseMod {

	@Override
	public String getVersion() {
		return ModInfoReader.getModInfoField("/immibis/mod_ImmibisCore.info.txt", "version");
	}
	
	private int coverModel;
	
	private Class coverSystemProxy;
	private Class coversNonSharedProxy;
	private Method renderWorldBlock, renderInvBlock;
	public static boolean coversEnabled;

	@Override
	public void load() {
		if(!CoreProxy.FORCE_MICROBLOCKS_DISABLED)
		{
			try {
				coverSystemProxy = Class.forName("immibis.core.covers.CoverSystemProxy");
				coversNonSharedProxy = Class.forName("immibis.core.covers.CoversNonSharedProxy");
				coverModel = ModLoader.getUniqueBlockModelID(this, true);
				renderWorldBlock = coversNonSharedProxy.getDeclaredMethod("RenderWorldBlock", RenderBlocks.class, IBlockAccess.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Block.class);
				renderInvBlock = coversNonSharedProxy.getDeclaredMethod("RenderInvBlock", RenderBlocks.class, Block.class, Integer.TYPE);
				coversEnabled = true;
				coverSystemProxy.getMethod("init", Integer.TYPE).invoke(null, coverModel);
			} catch(Exception e) {
				if(coverSystemProxy != null || !(e instanceof ClassNotFoundException))
					e.printStackTrace();
				coverSystemProxy = null;
				coverModel = -1;
				coversEnabled = false;
			}
		}
		else
			coversEnabled = false;
		CoreProxy.load();
	}
	
	@Override
	public boolean renderWorldBlock(RenderBlocks render, IBlockAccess world, int x, int y, int z, Block block, int model)
	{
		if(model == coverModel && coversEnabled)
			try {
				renderWorldBlock.invoke(null, render, world, x, y, z, block);
			} catch (IllegalArgumentException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		else if(model == BlockMultiTile.model)
			return ((BlockMultiTile)block).renderStatic(render, world, x, y, z);
		return false; // no second pass required
	}
	
	@Override
	public void renderInvBlock(RenderBlocks render, Block block, int meta, int model) {
		if(model == coverModel && coversEnabled)
			try {
				renderInvBlock.invoke(null, render, block, meta);
			} catch (IllegalArgumentException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		else if(model == BlockMultiTile.model)
			((ItemBlockMultiTile)Item.itemsList[block.blockID]).renderItem(render, meta);
	}
	
	@Override
	public void modsLoaded() {
		CoreProxy.AllocateBlockIDs();
		if(coversEnabled)
			try {
				coverSystemProxy.getDeclaredMethod("ModsLoaded").invoke(null);
			} catch (IllegalArgumentException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (SecurityException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (NoSuchMethodException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
	}
	
	public static mod_ImmibisCore instance;
	
	public mod_ImmibisCore() {
		instance = this;
	}

}
