package immibis.core;

import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import net.minecraft.src.Block;
import net.minecraft.src.Item;
import net.minecraft.src.Material;
import net.minecraft.src.ModLoader;

import net.minecraft.src.forge.Configuration; 
import net.minecraft.src.forge.MinecraftForge;
import net.minecraft.src.forge.Property;

public class Config {
	private static File configFile;
	private static Configuration config;
	private static boolean autoAssign;
	
	static {
		File configFile;
		{
			File configDir = new File(NonSharedProxy.getMinecraftDir(), "config");
			configDir.mkdir();
			configFile = new File(configDir, "immibis.cfg");
		}
		config = new Configuration(configFile);
		config.load();
		
		autoAssign = getBoolean("autoAssign", true);
		
		((Property)config.generalProperties.get("autoAssign")).value = "false";
		config.save();
	}
	
	public static boolean getBoolean(String name, boolean def)
	{
		boolean result = Boolean.valueOf(config.getOrCreateBooleanProperty(name, Configuration.CATEGORY_GENERAL, def).value);
		config.save();
		return result;
	}
	
	private static HashSet<String> forceAllowReassign = new HashSet<String>();
	
	public static void save() {
		config.save();
	}
	
	public static int getBlockID(String name, boolean allowCreation) {
		try {
			if(!allowCreation && !config.blockProperties.containsKey(name+".id"))
				return 0;
			return Integer.parseInt(config.getOrCreateBlockIdProperty(name+".id", 194).value);
		} catch(Exception e) {
			ModLoader.throwException("This shouldn't be possible", e);
			return 0;
		}
	}
	
	public static int getItemID(String name, int def)
	{
		Property prop = config.getOrCreateIntProperty(name, Configuration.CATEGORY_ITEM, def);
		int id = Integer.valueOf(prop.value);
		if(Item.itemsList[id] != null || id == 0)
		{
			if(!autoAssign)
				MinecraftForge.killMinecraft("immibis core", "Item "+name+" conflicts with "+Item.itemsList[id]+" ");
			id = -1;
			for(int k = Item.itemsList.length - 1; k >= 500; k--)
				if(Item.itemsList[k] == null)
				{
					id = k;
					break;
				}
			if(id == -1)
				MinecraftForge.killMinecraft("immibis core", "You're out of item IDs! Oh no! Remove some mods! (And congratulations... there are OVER THIRTY THOUSAND of them!)");
			prop.value = String.valueOf(id);
			config.save();
		}
		return id;
	}
	
	public static String getString(String name, String def, String category, String comment) {
		boolean save = config.categories.get(category) == null || config.categories.get(category).get(name) == null;
		Property prop = config.getOrCreateProperty(name, category, def);
		save |= (prop.comment == null && comment != null) || !prop.comment.equals(comment);
		prop.comment = comment;
		if(save)
			config.save();
		return prop.value;
	}

	public static int getInt(String name, int def)
	{
		return Integer.valueOf(config.getOrCreateIntProperty(name, Configuration.CATEGORY_GENERAL, def).value);
	}

	private static int maxBlockID = -1;
	public static int getMaxBlockID() {
		if(maxBlockID != -1)
			return maxBlockID;
		return maxBlockID = getInt("maxBlockID", 255);
	}
}
