package immibis.core;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

import net.minecraft.src.Block;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.ModLoader;
import net.minecraft.src.mod_ImmibisCore;
import immibis.core.net.*;

public class CoreProxy {
	public static final int PACKET_TYPE_S2C_STRING_GUI = 0;
	public static final int PACKET_TYPE_S2C_MULTIPART_DESCRIPTION = 1;
	
	public static final int PACKET_TYPE_C2S_MICROBLOCK_DIG_START = 0;
	public static final int PACKET_TYPE_C2S_MICROBLOCK_PLACE = 1;
	
	public static final boolean FORCE_MICROBLOCKS_DISABLED = true;
	
	public static final String CHANNEL_GUI = "Immibis1.2.5-GUI";
	
	private static HashMap<String, IBlockIDCallback> block_id_callbacks = new HashMap<String, IBlockIDCallback>();
	
	public static void RegisterBlockID(String name, IBlockIDCallback cb) {
		int id = Config.getBlockID(name, false);
		if(id != 0)
			cb.registerBlock(id);
		else
			block_id_callbacks.put(name, cb);
	}
	
	public static void load() {
		BlockMultiTile.model = BlockMultiTile.normalModel = NonSharedProxy.getUniqueBlockModelID(mod_ImmibisCore.instance, true);
		
		OneTwoFiveNetworking.initReceive(new IPacketMap() {
			@Override
			public IPacket createPacket(byte id) {
				if(id == 0)
					return new PacketButtonPress(0);
				return null;
			}
		}, CHANNEL_GUI);
	}
	
	public static void AllocateBlockIDs() {
		Config.save();
		for(Map.Entry<String, IBlockIDCallback> e : block_id_callbacks.entrySet())
		{
			e.getValue().registerBlock(Config.getBlockID(e.getKey(), true));
		}
		block_id_callbacks.clear();
		Config.save();
	}
}
