package immibis.core;

import java.util.ArrayList;

import net.minecraft.src.ItemBlock;
import net.minecraft.src.ItemStack;
import net.minecraft.src.ModLoader;

public class ItemCombined extends ItemBlock {
	public BlockCombined block;
	
	private String[] names;
	
	public ItemCombined(int id, String[] human_names)
    {
        super(id);
        setMaxDamage(0);
        setHasSubtypes(true);
        
        this.names = new String[16];
        for(int k = 0; k < human_names.length && k < 16; k++)
        {
        	this.names[k] = id+"."+k;
        	NonSharedProxy.AddLocalization(this.names[k] + ".name", human_names[k]);
        }
    }
	
	@Override
    public int getMetadata(int meta)
    {
        return meta;
    }

	@Override
    public String getItemNameIS(ItemStack stack)
    {
		int m = stack.getItemDamage();
		if(m >= 0 && m < 16 && names[m] != null)
			return names[m];
		return "";
    }
}
