package immibis.core.config;

import immibis.core.NonSharedProxy;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Stack;

public class ExtendedForgeConfigReader implements IConfigReader {
	private HashMap<String, String> keys = new HashMap<String, String>();
	
	public ExtendedForgeConfigReader(String path) throws IOException {
		File f = new File(NonSharedProxy.getMinecraftDir(), path);
		BufferedReader in = new BufferedReader(new FileReader(f));
		
		try
		{
			// Parses the very limited syntax generated by RedPower and Forge.
			
			Stack<String> up = new Stack<String>();
			String cur_path = "";
			while(true)
			{
				String line = in.readLine();
				if(line == null)
					break;
				line = line.trim();
				if(line.startsWith("#"))
					continue;
				if(line.endsWith("{"))
				{
					up.push(cur_path);
					String name = line.substring(0, line.indexOf("{")).trim();
					cur_path = (cur_path.equals("") ? name : cur_path + "." + name);
				}
				else if(line.indexOf("}") >= 0)
				{
					cur_path = up.pop();
				}
				else
				{
					int index = line.indexOf("=");
					if(index > 0)
					{
						String name = line.substring(0, index).trim();
						String value = line.substring(index + 1).trim();
						name = (cur_path.equals("") ? name : cur_path + "." + name);
						keys.put(name, value);
						//System.out.println(path+": " + name + " = " + value);
					}
				}
			}
		}
		finally
		{
			in.close();
		}
	}

	@Override
	public String getConfigEntry(String path) {
		return keys.get(path);
	}
}
