package immibis.core.covers;

import static immibis.core.covers.EnumPositionClass.*;
import static immibis.core.covers.EnumAxisPosition.*;

public enum EnumPosition {
	// DO NOT CHANGE ORDERING - Ordinals are saved in NBT
	// Changing ordering WILL break existing saves!
	
	Centre(EnumAxisPosition.Centre, EnumAxisPosition.Centre, EnumAxisPosition.Centre, EnumPositionClass.Centre),
	CoverNX(Negative, Span, Span, Face),
	CoverPX(Positive, Span, Span, Face),
	CoverNY(Span, Negative, Span, Face),
	CoverPY(Span, Positive, Span, Face),
	CoverNZ(Span, Span, Negative, Face),
	CoverPZ(Span, Span, Positive, Face),
	EdgeNXNY(Negative, Negative, Span, Edge),
	EdgeNXPY(Negative, Positive, Span, Edge),
	EdgePXNY(Positive, Negative, Span, Edge),
	EdgePXPY(Positive, Positive, Span, Edge),
	EdgeNXNZ(Negative, Span, Negative, Edge),
	EdgeNXPZ(Negative, Span, Positive, Edge),
	EdgePXNZ(Positive, Span, Negative, Edge),
	EdgePXPZ(Positive, Span, Positive, Edge),
	EdgeNYNZ(Span, Negative, Negative, Edge),
	EdgeNYPZ(Span, Negative, Positive, Edge),
	EdgePYNZ(Span, Positive, Negative, Edge),
	EdgePYPZ(Span, Positive, Positive, Edge),
	CornerNXNYNZ(Negative, Negative, Negative, Corner),
	CornerNXNYPZ(Negative, Negative, Positive, Corner),
	CornerNXPYNZ(Negative, Positive, Negative, Corner),
	CornerNXPYPZ(Negative, Positive, Positive, Corner),
	CornerPXNYNZ(Positive, Negative, Negative, Corner),
	CornerPXNYPZ(Positive, Negative, Positive, Corner),
	CornerPXPYNZ(Positive, Positive, Negative, Corner),
	CornerPXPYPZ(Positive, Positive, Positive, Corner),
	
	PostX(Span, EnumAxisPosition.Centre, EnumAxisPosition.Centre, Post),
	PostY(EnumAxisPosition.Centre, Span, EnumAxisPosition.Centre, Post),
	PostZ(EnumAxisPosition.Centre, EnumAxisPosition.Centre, Span, Post),
	
	;
	
	private EnumPosition(EnumAxisPosition x, EnumAxisPosition y, EnumAxisPosition z, EnumPositionClass clazz) {
		this.x = x;
		this.y = y;
		this.z = z;
		this.clazz = clazz;
	}
	
	public final EnumAxisPosition x, y, z;
	public final EnumPositionClass clazz;
	
	public static EnumPosition getCornerPos(int x, int y, int z) {
		if(x < 0)
			if(y < 0)
				if(z < 0)
					return CornerNXNYNZ;
				else
					return CornerNXNYPZ;
			else
				if(z < 0)
					return CornerNXPYNZ;
				else
					return CornerNXPYPZ;
		else
			if(y < 0)
				if(z < 0)
					return CornerPXNYNZ;
				else
					return CornerPXNYPZ;
			else
				if(z < 0)
					return CornerPXPYNZ;
				else
					return CornerPXPYPZ;
	}
}
