package immibis.core.covers;

import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.NBTBase;
import net.minecraft.src.NBTTagCompound;

public class Part {
	public final PartType type;
	public final double size;
	public final EnumPosition pos;
	
	public Part(PartType type, EnumPosition pos) {
		this.type = type;
		this.size = type.size;
		this.pos = pos;
	}
	
	private static double getMinFromAxisPosition(EnumAxisPosition ap, double size) {
		switch(ap) {
		case Span:
		case Negative:
			return 0;
		case Positive:
			return 1 - size;
		case Centre:
			return (1 - size) / 2;
		default:
			throw new IllegalArgumentException("ap");
		}
	}
	private static double getMaxFromAxisPosition(EnumAxisPosition ap, double size) {
		switch(ap) {
		case Span:
		case Positive:
			return 1;
		case Negative:
			return size;
		case Centre:
			return (1 + size) / 2;
		default:
			throw new IllegalArgumentException("ap");
		}
	}
	private double getMinFromAxisPosition(EnumAxisPosition ap) {
		switch(ap) {
		case Span:
		case Negative:
			return 0;
		case Positive:
			return 1 - size;
		case Centre:
			return (1 - size) / 2;
		default:
			throw new IllegalArgumentException("ap");
		}
	}
	private double getMaxFromAxisPosition(EnumAxisPosition ap) {
		switch(ap) {
		case Span:
		case Positive:
			return 1;
		case Negative:
			return size;
		case Centre:
			return (1 + size) / 2;
		default:
			throw new IllegalArgumentException("ap");
		}
	}
	
	protected AxisAlignedBB aabb;
	public AxisAlignedBB getBoundingBox() {
		if(aabb == null)
		{
			aabb = getBoundingBox(pos, size);
		}
		return aabb;
	}
	
	public static AxisAlignedBB getBoundingBox(EnumPosition pos, double size) {
		double minx = getMinFromAxisPosition(pos.x, size);
		double miny = getMinFromAxisPosition(pos.y, size);
		double minz = getMinFromAxisPosition(pos.z, size);
		double maxx = getMaxFromAxisPosition(pos.x, size);
		double maxy = getMaxFromAxisPosition(pos.y, size);
		double maxz = getMaxFromAxisPosition(pos.z, size);
		return AxisAlignedBB.getBoundingBox(minx, miny, minz, maxx, maxy, maxz);
	}

	public NBTBase writeToNBT() {
		NBTTagCompound c = new NBTTagCompound();
		c.setInteger("type", type.id);
		c.setByte("pos", (byte)pos.ordinal());
		return c;
	}

	public static Part readFromNBT(NBTBase tag) {
		NBTTagCompound c = (NBTTagCompound)tag;
		PartType type = CoverSystemProxy.parts.get(c.getInteger("type"));
		EnumPosition pos = EnumPosition.values()[c.getByte("pos")];
		Part p = new Part(type, pos);
		return p;
	}
}
