/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.blocks;

import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.TileEntityBlock;
import com.sk89q.worldedit.data.DataException;
import java.util.HashMap;
import java.util.Map;

public class SignBlock
extends BaseBlock
implements TileEntityBlock {
    private String[] text;

    public SignBlock(int type, int data) {
        super(type, data);
        this.text = new String[]{"", "", "", ""};
    }

    public SignBlock(int type, int data, String[] text) {
        super(type, data);
        this.text = text;
    }

    public String[] getText() {
        return this.text;
    }

    public void setText(String[] text) {
        this.text = text;
    }

    @Override
    public String getTileEntityID() {
        return "Sign";
    }

    @Override
    public Map<String, Tag> toTileEntityNBT() throws DataException {
        HashMap<String, Tag> values = new HashMap<String, Tag>();
        values.put("Text1", new StringTag("Text1", this.text[0]));
        values.put("Text2", new StringTag("Text2", this.text[1]));
        values.put("Text3", new StringTag("Text3", this.text[2]));
        values.put("Text4", new StringTag("Text4", this.text[3]));
        return values;
    }

    @Override
    public void fromTileEntityNBT(Map<String, Tag> values) throws DataException {
        if (values == null) {
            return;
        }
        this.text = new String[]{"", "", "", ""};
        Tag t = values.get("id");
        if (!(t instanceof StringTag) || !((StringTag)t).getValue().equals("Sign")) {
            throw new DataException("'Sign' tile entity expected");
        }
        t = values.get("Text1");
        if (t instanceof StringTag) {
            this.text[0] = ((StringTag)t).getValue();
        }
        if ((t = values.get("Text2")) instanceof StringTag) {
            this.text[1] = ((StringTag)t).getValue();
        }
        if ((t = values.get("Text3")) instanceof StringTag) {
            this.text[2] = ((StringTag)t).getValue();
        }
        if ((t = values.get("Text4")) instanceof StringTag) {
            this.text[3] = ((StringTag)t).getValue();
        }
    }
}

