/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.data;

import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.BlockVector2D;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.data.AnvilChunk;
import com.sk89q.worldedit.data.Chunk;
import com.sk89q.worldedit.data.DataException;
import com.sk89q.worldedit.data.OldChunk;
import java.io.IOException;

public abstract class ChunkStore {
    public static final int CHUNK_SHIFTS = 4;

    public static BlockVector2D toChunk(Vector pos) {
        int chunkX = (int)Math.floor((double)pos.getBlockX() / 16.0);
        int chunkZ = (int)Math.floor((double)pos.getBlockZ() / 16.0);
        return new BlockVector2D(chunkX, chunkZ);
    }

    public abstract CompoundTag getChunkTag(Vector2D var1, LocalWorld var2) throws DataException, IOException;

    public Chunk getChunk(Vector2D pos, LocalWorld world) throws DataException, IOException {
        CompoundTag tag = this.getChunkTag(pos, world);
        Object tags = tag.getValue();
        if (tags.containsKey("Sections")) {
            return new AnvilChunk(world, tag);
        }
        return new OldChunk(world, tag);
    }

    public void close() throws IOException {
    }

    public abstract boolean isValid();
}

