/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.regions;

import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.BlockVector2D;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.regions.AbstractRegion;
import com.sk89q.worldedit.regions.FlatRegion;
import com.sk89q.worldedit.regions.RegionOperationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class CuboidRegion
extends AbstractRegion
implements FlatRegion {
    private Vector pos1;
    private Vector pos2;

    public CuboidRegion(Vector pos1, Vector pos2) {
        this(null, pos1, pos2);
    }

    public CuboidRegion(LocalWorld world, Vector pos1, Vector pos2) {
        super(world);
        this.pos1 = pos1;
        this.pos2 = pos2;
    }

    @Override
    public Vector getMinimumPoint() {
        return new Vector(Math.min(this.pos1.getX(), this.pos2.getX()), Math.min(this.pos1.getY(), this.pos2.getY()), Math.min(this.pos1.getZ(), this.pos2.getZ()));
    }

    @Override
    public Vector getMaximumPoint() {
        return new Vector(Math.max(this.pos1.getX(), this.pos2.getX()), Math.max(this.pos1.getY(), this.pos2.getY()), Math.max(this.pos1.getZ(), this.pos2.getZ()));
    }

    @Override
    public int getArea() {
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        return (int)((max.getX() - min.getX() + 1.0) * (max.getY() - min.getY() + 1.0) * (max.getZ() - min.getZ() + 1.0));
    }

    @Override
    public int getWidth() {
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        return (int)(max.getX() - min.getX() + 1.0);
    }

    @Override
    public int getHeight() {
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        return (int)(max.getY() - min.getY() + 1.0);
    }

    @Override
    public int getLength() {
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        return (int)(max.getZ() - min.getZ() + 1.0);
    }

    @Override
    public void expand(Vector ... changes) {
        for (Vector change : changes) {
            if (change.getX() > 0.0) {
                if (Math.max(this.pos1.getX(), this.pos2.getX()) == this.pos1.getX()) {
                    this.pos1 = this.pos1.add(new Vector(change.getX(), 0.0, 0.0));
                } else {
                    this.pos2 = this.pos2.add(new Vector(change.getX(), 0.0, 0.0));
                }
            } else if (Math.min(this.pos1.getX(), this.pos2.getX()) == this.pos1.getX()) {
                this.pos1 = this.pos1.add(new Vector(change.getX(), 0.0, 0.0));
            } else {
                this.pos2 = this.pos2.add(new Vector(change.getX(), 0.0, 0.0));
            }
            if (change.getY() > 0.0) {
                if (Math.max(this.pos1.getY(), this.pos2.getY()) == this.pos1.getY()) {
                    this.pos1 = this.pos1.add(new Vector(0.0, change.getY(), 0.0));
                } else {
                    this.pos2 = this.pos2.add(new Vector(0.0, change.getY(), 0.0));
                }
            } else if (Math.min(this.pos1.getY(), this.pos2.getY()) == this.pos1.getY()) {
                this.pos1 = this.pos1.add(new Vector(0.0, change.getY(), 0.0));
            } else {
                this.pos2 = this.pos2.add(new Vector(0.0, change.getY(), 0.0));
            }
            if (change.getZ() > 0.0) {
                if (Math.max(this.pos1.getZ(), this.pos2.getZ()) == this.pos1.getZ()) {
                    this.pos1 = this.pos1.add(new Vector(0.0, 0.0, change.getZ()));
                    continue;
                }
                this.pos2 = this.pos2.add(new Vector(0.0, 0.0, change.getZ()));
                continue;
            }
            if (Math.min(this.pos1.getZ(), this.pos2.getZ()) == this.pos1.getZ()) {
                this.pos1 = this.pos1.add(new Vector(0.0, 0.0, change.getZ()));
                continue;
            }
            this.pos2 = this.pos2.add(new Vector(0.0, 0.0, change.getZ()));
        }
        this.recalculate();
    }

    @Override
    public void contract(Vector ... changes) {
        for (Vector change : changes) {
            if (change.getX() < 0.0) {
                if (Math.max(this.pos1.getX(), this.pos2.getX()) == this.pos1.getX()) {
                    this.pos1 = this.pos1.add(new Vector(change.getX(), 0.0, 0.0));
                } else {
                    this.pos2 = this.pos2.add(new Vector(change.getX(), 0.0, 0.0));
                }
            } else if (Math.min(this.pos1.getX(), this.pos2.getX()) == this.pos1.getX()) {
                this.pos1 = this.pos1.add(new Vector(change.getX(), 0.0, 0.0));
            } else {
                this.pos2 = this.pos2.add(new Vector(change.getX(), 0.0, 0.0));
            }
            if (change.getY() < 0.0) {
                if (Math.max(this.pos1.getY(), this.pos2.getY()) == this.pos1.getY()) {
                    this.pos1 = this.pos1.add(new Vector(0.0, change.getY(), 0.0));
                } else {
                    this.pos2 = this.pos2.add(new Vector(0.0, change.getY(), 0.0));
                }
            } else if (Math.min(this.pos1.getY(), this.pos2.getY()) == this.pos1.getY()) {
                this.pos1 = this.pos1.add(new Vector(0.0, change.getY(), 0.0));
            } else {
                this.pos2 = this.pos2.add(new Vector(0.0, change.getY(), 0.0));
            }
            if (change.getZ() < 0.0) {
                if (Math.max(this.pos1.getZ(), this.pos2.getZ()) == this.pos1.getZ()) {
                    this.pos1 = this.pos1.add(new Vector(0.0, 0.0, change.getZ()));
                    continue;
                }
                this.pos2 = this.pos2.add(new Vector(0.0, 0.0, change.getZ()));
                continue;
            }
            if (Math.min(this.pos1.getZ(), this.pos2.getZ()) == this.pos1.getZ()) {
                this.pos1 = this.pos1.add(new Vector(0.0, 0.0, change.getZ()));
                continue;
            }
            this.pos2 = this.pos2.add(new Vector(0.0, 0.0, change.getZ()));
        }
        this.recalculate();
    }

    private void recalculate() {
        this.pos1 = this.pos1.clampY(0, this.world == null ? 255 : this.world.getMaxY());
        this.pos2 = this.pos2.clampY(0, this.world == null ? 255 : this.world.getMaxY());
    }

    @Override
    public void shift(Vector change) throws RegionOperationException {
        this.pos1 = this.pos1.add(change);
        this.pos2 = this.pos2.add(change);
        this.recalculate();
    }

    public Vector getPos1() {
        return this.pos1;
    }

    public void setPos1(Vector pos1) {
        this.pos1 = pos1;
    }

    public Vector getPos2() {
        return this.pos2;
    }

    public void setPos2(Vector pos2) {
        this.pos2 = pos2;
    }

    @Override
    public Set<Vector2D> getChunks() {
        HashSet<Vector2D> chunks = new HashSet<Vector2D>();
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        for (int x = min.getBlockX(); x <= max.getBlockX(); ++x) {
            for (int z = min.getBlockZ(); z <= max.getBlockZ(); ++z) {
                chunks.add(new BlockVector2D(x >> 4, z >> 4));
            }
        }
        return chunks;
    }

    @Override
    public Set<Vector> getChunkCubes() {
        HashSet<Vector> chunks = new HashSet<Vector>();
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        for (int x = min.getBlockX(); x <= max.getBlockX(); ++x) {
            for (int y = min.getBlockY(); y <= max.getBlockY(); ++y) {
                for (int z = min.getBlockZ(); z <= max.getBlockZ(); ++z) {
                    chunks.add(new BlockVector(x >> 4, y >> 4, z >> 4));
                }
            }
        }
        return chunks;
    }

    @Override
    public boolean contains(Vector pt) {
        double x = pt.getX();
        double y = pt.getY();
        double z = pt.getZ();
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        return x >= (double)min.getBlockX() && x <= (double)max.getBlockX() && y >= (double)min.getBlockY() && y <= (double)max.getBlockY() && z >= (double)min.getBlockZ() && z <= (double)max.getBlockZ();
    }

    @Override
    public Iterator<BlockVector> iterator() {
        return new Iterator<BlockVector>(){
            private Vector min;
            private Vector max;
            private int nextX;
            private int nextY;
            private int nextZ;
            {
                this.min = CuboidRegion.this.getMinimumPoint();
                this.max = CuboidRegion.this.getMaximumPoint();
                this.nextX = this.min.getBlockX();
                this.nextY = this.min.getBlockY();
                this.nextZ = this.min.getBlockZ();
            }

            @Override
            public boolean hasNext() {
                return this.nextX != Integer.MIN_VALUE;
            }

            @Override
            public BlockVector next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                BlockVector answer = new BlockVector(this.nextX, this.nextY, this.nextZ);
                if (++this.nextX > this.max.getBlockX()) {
                    this.nextX = this.min.getBlockX();
                    if (++this.nextY > this.max.getBlockY()) {
                        this.nextY = this.min.getBlockY();
                        if (++this.nextZ > this.max.getBlockZ()) {
                            this.nextX = Integer.MIN_VALUE;
                        }
                    }
                }
                return answer;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Iterable<Vector2D> asFlatRegion() {
        return new Iterable<Vector2D>(){

            @Override
            public Iterator<Vector2D> iterator() {
                return new Iterator<Vector2D>(){
                    private Vector min;
                    private Vector max;
                    private int nextX;
                    private int nextZ;
                    {
                        this.min = CuboidRegion.this.getMinimumPoint();
                        this.max = CuboidRegion.this.getMaximumPoint();
                        this.nextX = this.min.getBlockX();
                        this.nextZ = this.min.getBlockZ();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.nextX != Integer.MIN_VALUE;
                    }

                    @Override
                    public Vector2D next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        Vector2D answer = new Vector2D(this.nextX, this.nextZ);
                        if (++this.nextX > this.max.getBlockX()) {
                            this.nextX = this.min.getBlockX();
                            if (++this.nextZ > this.max.getBlockZ()) {
                                this.nextX = Integer.MIN_VALUE;
                            }
                        }
                        return answer;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public String toString() {
        return this.getMinimumPoint() + " - " + this.getMaximumPoint();
    }

    @Override
    public CuboidRegion clone() {
        return (CuboidRegion)super.clone();
    }
}

