/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.spout;

import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bags.BlockBag;
import com.sk89q.worldedit.bags.BlockBagException;
import com.sk89q.worldedit.bags.OutOfBlocksException;
import com.sk89q.worldedit.bags.OutOfSpaceException;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.blocks.BaseItemStack;
import org.spout.api.inventory.Inventory;
import org.spout.api.inventory.ItemStack;
import org.spout.api.material.Material;
import org.spout.api.material.MaterialRegistry;
import org.spout.api.player.Player;

public class SpoutPlayerBlockBag
extends BlockBag {
    private Player player;
    private ItemStack[] items;

    public SpoutPlayerBlockBag(Player player) {
        this.player = player;
    }

    private void loadInventory() {
        if (this.items == null) {
            this.items = this.player.getEntity().getInventory().getContents();
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    @Override
    public void fetchItem(BaseItem item) throws BlockBagException {
        int amount;
        short id = (short)item.getType();
        short damage = item.getDamage();
        int n = amount = item instanceof BaseItemStack ? ((BaseItemStack)item).getAmount() : 1;
        assert (amount == 1);
        Material mat = MaterialRegistry.get((short)id);
        if (mat.hasSubMaterials()) {
            mat = mat.getSubMaterial(damage);
        }
        if (id == 0) {
            throw new IllegalArgumentException("Can't fetch air block");
        }
        this.loadInventory();
        boolean found = false;
        for (int slot = 0; slot < this.items.length; ++slot) {
            ItemStack bukkitItem = this.items[slot];
            if (bukkitItem == null || !bukkitItem.getMaterial().equals(mat)) continue;
            int currentAmount = bukkitItem.getAmount();
            if (currentAmount < 0) {
                return;
            }
            if (currentAmount > 1) {
                bukkitItem.setAmount(currentAmount - 1);
                found = true;
                break;
            }
            this.items[slot] = null;
            found = true;
            break;
        }
        if (!found) {
            throw new OutOfBlocksException();
        }
    }

    @Override
    public void storeItem(BaseItem item) throws BlockBagException {
        int amount;
        short id = (short)item.getType();
        short damage = item.getDamage();
        Material mat = MaterialRegistry.get((short)id);
        if (mat.hasSubMaterials()) {
            mat = mat.getSubMaterial(damage);
        }
        int n = amount = item instanceof BaseItemStack ? ((BaseItemStack)item).getAmount() : 1;
        assert (amount <= mat.getMaxStackSize());
        if (id == 0) {
            throw new IllegalArgumentException("Can't store air block");
        }
        this.loadInventory();
        int freeSlot = -1;
        for (int slot = 0; slot < this.items.length; ++slot) {
            ItemStack bukkitItem = this.items[slot];
            if (bukkitItem == null) {
                if (freeSlot != -1) continue;
                freeSlot = slot;
                continue;
            }
            if (!bukkitItem.getMaterial().equals(mat)) continue;
            int currentAmount = bukkitItem.getAmount();
            if (currentAmount < 0) {
                return;
            }
            if (currentAmount >= mat.getMaxStackSize()) continue;
            int spaceLeft = mat.getMaxStackSize() - currentAmount;
            if (spaceLeft >= amount) {
                bukkitItem.setAmount(currentAmount + amount);
                return;
            }
            bukkitItem.setAmount(mat.getMaxStackSize());
            amount -= spaceLeft;
        }
        if (freeSlot > -1) {
            this.items[freeSlot] = new ItemStack(mat, amount);
            return;
        }
        throw new OutOfSpaceException(id);
    }

    @Override
    public void flushChanges() {
        if (this.items != null) {
            Inventory inv = this.player.getEntity().getInventory();
            for (int i = 0; i < this.items.length && i < this.player.getEntity().getInventorySize(); ++i) {
                inv.setItem(this.items[i], i);
            }
            this.items = null;
        }
    }

    @Override
    public void addSourcePosition(WorldVector pos) {
    }

    @Override
    public void addSingleSourcePosition(WorldVector pos) {
    }
}

