/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.spout;

import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditOperation;
import com.sk89q.worldedit.bags.BlockBag;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Polygonal2DRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionSelector;
import com.sk89q.worldedit.spout.SessionTimer;
import com.sk89q.worldedit.spout.SpoutCommandSender;
import com.sk89q.worldedit.spout.SpoutConfiguration;
import com.sk89q.worldedit.spout.SpoutPlayer;
import com.sk89q.worldedit.spout.SpoutServerInterface;
import com.sk89q.worldedit.spout.SpoutUtil;
import com.sk89q.worldedit.spout.SpoutWorld;
import com.sk89q.worldedit.spout.WorldEditListener;
import com.sk89q.worldedit.spout.selections.CuboidSelection;
import com.sk89q.worldedit.spout.selections.Polygonal2DSelection;
import com.sk89q.worldedit.spout.selections.Selection;
import com.sk89q.worldedit.util.YAMLConfiguration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.spout.api.command.CommandSource;
import org.spout.api.event.Listener;
import org.spout.api.geo.World;
import org.spout.api.player.Player;
import org.spout.api.plugin.CommonPlugin;
import org.spout.api.plugin.Plugin;
import org.spout.api.util.Named;

public class WorldEditPlugin
extends CommonPlugin
implements Named {
    private SpoutServerInterface server;
    private WorldEdit controller;
    private YAMLConfiguration config;
    private static WorldEditPlugin instance;

    public WorldEditPlugin() {
        instance = this;
    }

    public void onEnable() {
        String pluginYmlVersion = this.getDescription().getVersion();
        String manifestVersion = WorldEdit.getVersion();
        this.getLogger().info("WorldEdit " + pluginYmlVersion + " enabled.");
        if (!manifestVersion.equalsIgnoreCase(pluginYmlVersion)) {
            WorldEdit.setVersion(manifestVersion + " (" + pluginYmlVersion + ")");
        }
        this.getDataFolder().mkdirs();
        this.createDefaultConfiguration("config.yml");
        this.config = new SpoutConfiguration(new YAMLProcessor(new File(this.getDataFolder(), "config.yml"), true), this);
        this.loadConfiguration();
        this.server = new SpoutServerInterface(this, this.getGame());
        this.controller = new WorldEdit(this.server, this.config);
        this.registerEvents();
        this.getGame().getScheduler().scheduleAsyncRepeatingTask((Plugin)this, (Runnable)new SessionTimer(this.controller, this.getGame()), 120L, 120L);
    }

    public void onDisable() {
        for (Player player : this.getGame().getOnlinePlayers()) {
            SpoutPlayer lPlayer = this.wrapPlayer(player);
            if (!this.controller.getSession(lPlayer).hasCUISupport()) continue;
            ((LocalPlayer)lPlayer).dispatchCUIHandshake();
        }
        this.controller.clearSessions();
        this.config.unload();
        this.getGame().getScheduler().cancelTasks((Plugin)this);
    }

    protected void loadConfiguration() {
        this.config.unload();
        this.config.load();
    }

    protected void registerEvents() {
        this.getGame().getEventManager().registerEvents((Listener)new WorldEditListener(this), (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDefaultConfiguration(String name) {
        File actual = new File(this.getDataFolder(), name);
        if (!actual.exists()) {
            InputStream input = null;
            try {
                JarFile file = new JarFile(this.getFile());
                ZipEntry copy = file.getEntry("defaults/" + name);
                if (copy == null) {
                    throw new FileNotFoundException();
                }
                input = file.getInputStream(copy);
            }
            catch (IOException e) {
                this.getLogger().severe("Unable to read default configuration: " + name);
            }
            if (input != null) {
                FileOutputStream output = null;
                try {
                    output = new FileOutputStream(actual);
                    byte[] buf = new byte[8192];
                    int length = 0;
                    while ((length = input.read(buf)) > 0) {
                        output.write(buf, 0, length);
                    }
                    this.getLogger().info("Default configuration file written: " + name);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        input.close();
                    }
                    catch (IOException ignore) {}
                    try {
                        if (output != null) {
                            output.close();
                        }
                    }
                    catch (IOException ignore) {}
                }
            }
        }
    }

    public LocalSession getSession(Player player) {
        return this.controller.getSession(this.wrapPlayer(player));
    }

    public EditSession createEditSession(Player player) {
        SpoutPlayer wePlayer = this.wrapPlayer(player);
        LocalSession session = this.controller.getSession(wePlayer);
        BlockBag blockBag = session.getBlockBag(wePlayer);
        EditSession editSession = new EditSession(((LocalPlayer)wePlayer).getWorld(), session.getBlockChangeLimit(), blockBag);
        editSession.enableQueue();
        return editSession;
    }

    public void remember(Player player, EditSession editSession) {
        SpoutPlayer wePlayer = this.wrapPlayer(player);
        LocalSession session = this.controller.getSession(wePlayer);
        session.remember(editSession);
        editSession.flushQueue();
        this.controller.flushBlockBag(wePlayer, editSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(Player player, WorldEditOperation op) throws Throwable {
        SpoutPlayer wePlayer = this.wrapPlayer(player);
        LocalSession session = this.controller.getSession(wePlayer);
        EditSession editSession = this.createEditSession(player);
        try {
            op.run(session, wePlayer, editSession);
        }
        finally {
            this.remember(player, editSession);
        }
    }

    public YAMLConfiguration getLocalConfiguration() {
        return this.config;
    }

    public SpoutPlayer wrapPlayer(Player player) {
        return new SpoutPlayer(this, this.server, player);
    }

    public LocalPlayer wrapCommandSender(CommandSource sender) {
        if (sender instanceof Player) {
            return this.wrapPlayer((Player)sender);
        }
        return new SpoutCommandSender(this, this.server, sender);
    }

    public SpoutServerInterface getServerInterface() {
        return this.server;
    }

    public WorldEdit getWorldEdit() {
        return this.controller;
    }

    public Selection getSelection(Player player) {
        if (player == null) {
            throw new IllegalArgumentException("Null player not allowed");
        }
        if (!player.isOnline()) {
            throw new IllegalArgumentException("Offline player not allowed");
        }
        LocalSession session = this.controller.getSession(this.wrapPlayer(player));
        RegionSelector selector = session.getRegionSelector(SpoutUtil.getLocalWorld(player.getEntity().getWorld()));
        try {
            Region region = selector.getRegion();
            World world = ((SpoutWorld)session.getSelectionWorld()).getWorld();
            if (region instanceof CuboidRegion) {
                return new CuboidSelection(world, selector, (CuboidRegion)region);
            }
            if (region instanceof Polygonal2DRegion) {
                return new Polygonal2DSelection(world, selector, (Polygonal2DRegion)region);
            }
            return null;
        }
        catch (IncompleteRegionException e) {
            return null;
        }
    }

    public void setSelection(Player player, Selection selection) {
        if (player == null) {
            throw new IllegalArgumentException("Null player not allowed");
        }
        if (!player.isOnline()) {
            throw new IllegalArgumentException("Offline player not allowed");
        }
        if (selection == null) {
            throw new IllegalArgumentException("Null selection not allowed");
        }
        LocalSession session = this.controller.getSession(this.wrapPlayer(player));
        RegionSelector sel = selection.getRegionSelector();
        session.setRegionSelector(SpoutUtil.getLocalWorld(player.getEntity().getWorld()), sel);
        session.dispatchCUISelection(this.wrapPlayer(player));
    }

    public String getName() {
        return this.getDescription().getName();
    }

    static WorldEditPlugin getInstance() {
        return instance;
    }
}

