/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit;

import com.sk89q.worldedit.Vector;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.blacklist.events.BlockBreakBlacklistEvent;
import com.sk89q.worldguard.blacklist.events.ItemUseBlacklistEvent;
import com.sk89q.worldguard.bukkit.BukkitUtil;
import com.sk89q.worldguard.bukkit.ConfigurationManager;
import com.sk89q.worldguard.bukkit.RegionQueryUtil;
import com.sk89q.worldguard.bukkit.WorldConfiguration;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.GlobalRegionManager;
import com.sk89q.worldguard.protection.events.DisallowedPVPEvent;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Wolf;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.CreeperPowerEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.PigZapEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.painting.PaintingBreakByEntityEvent;
import org.bukkit.event.painting.PaintingBreakEvent;
import org.bukkit.event.painting.PaintingPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class WorldGuardEntityListener
implements Listener {
    private WorldGuardPlugin plugin;

    public WorldGuardEntityListener(WorldGuardPlugin plugin) {
        this.plugin = plugin;
    }

    public void registerEvents() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityInteract(EntityInteractEvent event) {
        Entity entity = event.getEntity();
        Block block = event.getBlock();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(entity.getWorld());
        if (block.getTypeId() == 60 && entity instanceof Creature && wcfg.disableCreatureCropTrampling) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityDeath(EntityDeathEvent event) {
        WorldConfiguration wcfg = this.plugin.getGlobalStateManager().get(event.getEntity().getWorld());
        if (wcfg.disableExpDrops || !this.plugin.getGlobalRegionManager().allows(DefaultFlag.EXP_DROPS, event.getEntity().getLocation())) {
            event.setDroppedExp(0);
        }
        if (event instanceof PlayerDeathEvent && wcfg.disableDeathMessages) {
            ((PlayerDeathEvent)event).setDeathMessage("");
        }
    }

    private void onEntityDamageByBlock(EntityDamageByBlockEvent event) {
        Entity defender = event.getEntity();
        EntityDamageEvent.DamageCause type = event.getCause();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(defender.getWorld());
        if (defender instanceof Wolf && ((Wolf)defender).isTamed()) {
            if (wcfg.antiWolfDumbness && type != EntityDamageEvent.DamageCause.VOID) {
                event.setCancelled(true);
                return;
            }
        } else if (defender instanceof Player) {
            Player player = (Player)defender;
            if (this.isInvincible(player)) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.disableLavaDamage && type == EntityDamageEvent.DamageCause.LAVA) {
                event.setCancelled(true);
                player.setFireTicks(0);
                return;
            }
            if (wcfg.disableContactDamage && type == EntityDamageEvent.DamageCause.CONTACT) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.teleportOnVoid && type == EntityDamageEvent.DamageCause.VOID) {
                BukkitUtil.findFreePosition(player);
                event.setCancelled(true);
                return;
            }
            if (wcfg.disableVoidDamage && type == EntityDamageEvent.DamageCause.VOID) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.disableExplosionDamage && type == EntityDamageEvent.DamageCause.BLOCK_EXPLOSION) {
                event.setCancelled(true);
                return;
            }
        }
    }

    private void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Player player;
        if (event.getCause() == EntityDamageEvent.DamageCause.PROJECTILE) {
            this.onEntityDamageByProjectile(event);
            return;
        }
        Entity attacker = event.getDamager();
        Entity defender = event.getEntity();
        if (attacker instanceof Player) {
            player = (Player)attacker;
            ConfigurationManager cfg = this.plugin.getGlobalStateManager();
            WorldConfiguration wcfg = cfg.get(player.getWorld());
            ItemStack held = player.getInventory().getItemInHand();
            if (held != null && wcfg.getBlacklist() != null && !wcfg.getBlacklist().check(new ItemUseBlacklistEvent(this.plugin.wrapPlayer(player), BukkitUtil.toVector(player.getLocation()), held.getTypeId()), false, false)) {
                event.setCancelled(true);
                return;
            }
        }
        if (defender instanceof Player) {
            ApplicableRegionSet set;
            RegionManager mgr;
            RegionManager mgr2;
            Vector pt;
            player = (Player)defender;
            LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
            ConfigurationManager cfg = this.plugin.getGlobalStateManager();
            WorldConfiguration wcfg = cfg.get(player.getWorld());
            if (this.isInvincible(player)) {
                if (!(!wcfg.regionInvinciblityRemovesMobs || !(attacker instanceof LivingEntity) || attacker instanceof Player || attacker instanceof Tameable && ((Tameable)attacker).isTamed())) {
                    attacker.remove();
                }
                event.setCancelled(true);
                return;
            }
            if (wcfg.disableLightningDamage && event.getCause() == EntityDamageEvent.DamageCause.LIGHTNING) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.disableExplosionDamage && event.getCause() == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION) {
                event.setCancelled(true);
                return;
            }
            if (attacker != null && attacker instanceof Player && wcfg.useRegions) {
                pt = BukkitUtil.toVector(defender.getLocation());
                Vector pt2 = BukkitUtil.toVector(attacker.getLocation());
                mgr2 = this.plugin.getGlobalRegionManager().get(player.getWorld());
                if (!mgr2.getApplicableRegions(pt).allows(DefaultFlag.PVP, localPlayer) || !mgr2.getApplicableRegions(pt2).allows(DefaultFlag.PVP, this.plugin.wrapPlayer((Player)attacker))) {
                    this.tryCancelPVPEvent((Player)attacker, player, event);
                    return;
                }
            }
            if (attacker != null && attacker instanceof TNTPrimed) {
                if (wcfg.blockTNTExplosions) {
                    event.setCancelled(true);
                    return;
                }
                if (wcfg.useRegions) {
                    pt = BukkitUtil.toVector(defender.getLocation());
                    mgr = this.plugin.getGlobalRegionManager().get(player.getWorld());
                    set = mgr.getApplicableRegions(pt);
                    if (!set.allows(DefaultFlag.TNT, localPlayer)) {
                        event.setCancelled(true);
                        return;
                    }
                }
            }
            if (attacker != null && attacker instanceof Fireball) {
                if (wcfg.blockFireballExplosions) {
                    event.setCancelled(true);
                    return;
                }
                if (wcfg.useRegions) {
                    Fireball fireball = (Fireball)attacker;
                    Vector pt2 = BukkitUtil.toVector(defender.getLocation());
                    mgr2 = this.plugin.getGlobalRegionManager().get(player.getWorld());
                    ApplicableRegionSet set2 = mgr2.getApplicableRegions(pt2);
                    if (fireball.getShooter() instanceof Player) {
                        Vector pt22 = BukkitUtil.toVector(fireball.getShooter().getLocation());
                        if (!set2.allows(DefaultFlag.PVP, localPlayer) || !mgr2.getApplicableRegions(pt22).allows(DefaultFlag.PVP, this.plugin.wrapPlayer((Player)fireball.getShooter()))) {
                            this.tryCancelPVPEvent((Player)fireball.getShooter(), player, event);
                            return;
                        }
                    } else if (!set2.allows(DefaultFlag.GHAST_FIREBALL, localPlayer)) {
                        event.setCancelled(true);
                        return;
                    }
                }
            }
            if (attacker != null && attacker instanceof LivingEntity && !(attacker instanceof Player)) {
                if (attacker instanceof Creeper && wcfg.blockCreeperExplosions) {
                    event.setCancelled(true);
                    return;
                }
                if (wcfg.disableMobDamage) {
                    event.setCancelled(true);
                    return;
                }
                if (wcfg.useRegions) {
                    pt = BukkitUtil.toVector(defender.getLocation());
                    mgr = this.plugin.getGlobalRegionManager().get(player.getWorld());
                    set = mgr.getApplicableRegions(pt);
                    if (!set.allows(DefaultFlag.MOB_DAMAGE, localPlayer)) {
                        event.setCancelled(true);
                        return;
                    }
                    if (attacker instanceof Creeper && !set.allows(DefaultFlag.CREEPER_EXPLOSION, localPlayer)) {
                        event.setCancelled(true);
                        return;
                    }
                }
            }
        }
    }

    private void onEntityDamageByProjectile(EntityDamageByEntityEvent event) {
        Entity defender = event.getEntity();
        LivingEntity attacker = ((Projectile)event.getDamager()).getShooter();
        if (defender instanceof Player) {
            Vector pt;
            Player player = (Player)defender;
            LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
            ConfigurationManager cfg = this.plugin.getGlobalStateManager();
            WorldConfiguration wcfg = cfg.get(player.getWorld());
            if (this.isInvincible(player)) {
                event.setCancelled(true);
                return;
            }
            if (attacker != null && attacker instanceof Player && wcfg.useRegions) {
                pt = BukkitUtil.toVector(defender.getLocation());
                Vector pt2 = BukkitUtil.toVector(attacker.getLocation());
                RegionManager mgr = this.plugin.getGlobalRegionManager().get(player.getWorld());
                if (!mgr.getApplicableRegions(pt).allows(DefaultFlag.PVP, localPlayer) || !mgr.getApplicableRegions(pt2).allows(DefaultFlag.PVP, this.plugin.wrapPlayer((Player)attacker))) {
                    this.tryCancelPVPEvent((Player)attacker, player, event);
                    return;
                }
            }
            if (attacker != null && attacker instanceof Skeleton) {
                if (wcfg.disableMobDamage) {
                    event.setCancelled(true);
                    return;
                }
                if (wcfg.useRegions) {
                    pt = BukkitUtil.toVector(defender.getLocation());
                    RegionManager mgr = this.plugin.getGlobalRegionManager().get(player.getWorld());
                    if (!mgr.getApplicableRegions(pt).allows(DefaultFlag.MOB_DAMAGE, localPlayer)) {
                        event.setCancelled(true);
                        return;
                    }
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        if (event instanceof EntityDamageByEntityEvent) {
            this.onEntityDamageByEntity((EntityDamageByEntityEvent)event);
            return;
        }
        if (event instanceof EntityDamageByBlockEvent) {
            this.onEntityDamageByBlock((EntityDamageByBlockEvent)event);
            return;
        }
        Entity defender = event.getEntity();
        EntityDamageEvent.DamageCause type = event.getCause();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(defender.getWorld());
        if (defender instanceof Wolf && ((Wolf)defender).isTamed()) {
            if (wcfg.antiWolfDumbness) {
                event.setCancelled(true);
                return;
            }
        } else if (defender instanceof Player) {
            Player player = (Player)defender;
            if (this.isInvincible(player)) {
                event.setCancelled(true);
                player.setFireTicks(0);
                return;
            }
            if (type == EntityDamageEvent.DamageCause.DROWNING && cfg.hasAmphibiousMode(player)) {
                player.setRemainingAir(player.getMaximumAir());
                event.setCancelled(true);
                return;
            }
            ItemStack helmet = player.getInventory().getHelmet();
            if (type == EntityDamageEvent.DamageCause.DROWNING && wcfg.pumpkinScuba && helmet != null && (helmet.getTypeId() == 86 || helmet.getTypeId() == 91)) {
                player.setRemainingAir(player.getMaximumAir());
                event.setCancelled(true);
                return;
            }
            if (wcfg.disableFallDamage && type == EntityDamageEvent.DamageCause.FALL) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.disableFireDamage && (type == EntityDamageEvent.DamageCause.FIRE || type == EntityDamageEvent.DamageCause.FIRE_TICK)) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.disableDrowningDamage && type == EntityDamageEvent.DamageCause.DROWNING) {
                player.setRemainingAir(player.getMaximumAir());
                event.setCancelled(true);
                return;
            }
            if (wcfg.teleportOnSuffocation && type == EntityDamageEvent.DamageCause.SUFFOCATION) {
                BukkitUtil.findFreePosition(player);
                event.setCancelled(true);
                return;
            }
            if (wcfg.disableSuffocationDamage && type == EntityDamageEvent.DamageCause.SUFFOCATION) {
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityCombust(EntityCombustEvent event) {
        Player player;
        Entity entity = event.getEntity();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(entity.getWorld());
        if (entity instanceof Player && (cfg.hasGodMode(player = (Player)entity) || wcfg.useRegions && RegionQueryUtil.isInvincible(this.plugin, player))) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityExplode(EntityExplodeEvent event) {
        RegionManager mgr;
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        Location l = event.getLocation();
        World world = l.getWorld();
        WorldConfiguration wcfg = cfg.get(world);
        Entity ent = event.getEntity();
        if (cfg.activityHaltToggle) {
            ent.remove();
            event.setCancelled(true);
            return;
        }
        if (ent instanceof Creeper) {
            if (wcfg.blockCreeperBlockDamage) {
                event.blockList().clear();
                return;
            }
            if (wcfg.blockCreeperExplosions) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.useRegions && wcfg.useRegions) {
                mgr = this.plugin.getGlobalRegionManager().get(world);
                for (Block block : event.blockList()) {
                    if (mgr.getApplicableRegions((Vector)BukkitUtil.toVector(block)).allows(DefaultFlag.CREEPER_EXPLOSION)) continue;
                    event.blockList().clear();
                    return;
                }
            }
        } else if (ent instanceof EnderDragon) {
            if (wcfg.blockEnderDragonBlockDamage) {
                event.blockList().clear();
                return;
            }
            if (wcfg.useRegions && wcfg.useRegions) {
                mgr = this.plugin.getGlobalRegionManager().get(world);
                for (Block block : event.blockList()) {
                    if (mgr.getApplicableRegions((Vector)BukkitUtil.toVector(block)).allows(DefaultFlag.ENDERDRAGON_BLOCK_DAMAGE)) continue;
                    event.blockList().clear();
                    return;
                }
            }
        } else if (ent instanceof TNTPrimed) {
            if (wcfg.blockTNTBlockDamage) {
                event.blockList().clear();
                return;
            }
            if (wcfg.blockTNTExplosions) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.useRegions) {
                mgr = this.plugin.getGlobalRegionManager().get(world);
                for (Block block : event.blockList()) {
                    if (mgr.getApplicableRegions((Vector)BukkitUtil.toVector(block)).allows(DefaultFlag.TNT)) continue;
                    event.blockList().clear();
                    return;
                }
            }
        } else if (ent instanceof Fireball) {
            if (wcfg.blockFireballBlockDamage) {
                event.blockList().clear();
                return;
            }
            if (wcfg.blockFireballExplosions) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.useRegions) {
                mgr = this.plugin.getGlobalRegionManager().get(world);
                for (Block block : event.blockList()) {
                    if (mgr.getApplicableRegions((Vector)BukkitUtil.toVector(block)).allows(DefaultFlag.GHAST_FIREBALL)) continue;
                    event.blockList().clear();
                    return;
                }
            }
        }
        if (wcfg.signChestProtection) {
            for (Block block : event.blockList()) {
                if (!wcfg.isChestProtected(block)) continue;
                event.blockList().clear();
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onExplosionPrime(ExplosionPrimeEvent event) {
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        Entity ent = event.getEntity();
        if (cfg.activityHaltToggle) {
            ent.remove();
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        if (cfg.activityHaltToggle) {
            event.setCancelled(true);
            return;
        }
        WorldConfiguration wcfg = cfg.get(event.getEntity().getWorld());
        EntityType entityType = event.getEntityType();
        if (wcfg.blockCreatureSpawn.contains(entityType)) {
            event.setCancelled(true);
            return;
        }
        Location eventLoc = event.getLocation();
        if (wcfg.useRegions) {
            Vector pt = BukkitUtil.toVector(eventLoc);
            RegionManager mgr = this.plugin.getGlobalRegionManager().get(eventLoc.getWorld());
            if (mgr == null) {
                return;
            }
            ApplicableRegionSet set = mgr.getApplicableRegions(pt);
            if (!set.allows(DefaultFlag.MOB_SPAWNING)) {
                event.setCancelled(true);
                return;
            }
            Set entityTypes = (Set)set.getFlag(DefaultFlag.DENY_SPAWN);
            if (entityTypes != null && entityTypes.contains(entityType)) {
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPigZap(PigZapEvent event) {
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(event.getEntity().getWorld());
        if (wcfg.disablePigZap) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onCreeperPower(CreeperPowerEvent event) {
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(event.getEntity().getWorld());
        if (wcfg.disableCreeperPower) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPaintingBreak(PaintingBreakEvent breakEvent) {
        if (!(breakEvent instanceof PaintingBreakByEntityEvent)) {
            return;
        }
        PaintingBreakByEntityEvent event = (PaintingBreakByEntityEvent)breakEvent;
        Painting painting = event.getPainting();
        World world = painting.getWorld();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(world);
        if (event.getRemover() instanceof Player) {
            Player player = (Player)event.getRemover();
            if (wcfg.getBlacklist() != null && !wcfg.getBlacklist().check(new BlockBreakBlacklistEvent(this.plugin.wrapPlayer(player), BukkitUtil.toVector(player.getLocation()), 321), false, false)) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.useRegions && !this.plugin.getGlobalRegionManager().canBuild(player, painting.getLocation())) {
                player.sendMessage(ChatColor.DARK_RED + "You don't have permission for this area.");
                event.setCancelled(true);
                return;
            }
        } else {
            if (event.getRemover() instanceof Creeper) {
                if (wcfg.blockCreeperBlockDamage || wcfg.blockCreeperExplosions) {
                    event.setCancelled(true);
                    return;
                }
                if (wcfg.useRegions && !this.plugin.getGlobalRegionManager().allows(DefaultFlag.CREEPER_EXPLOSION, painting.getLocation())) {
                    event.setCancelled(true);
                    return;
                }
            }
            if (wcfg.blockEntityPaintingDestroy) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.useRegions && !this.plugin.getGlobalRegionManager().allows(DefaultFlag.ENTITY_PAINTING_DESTROY, painting.getLocation())) {
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPaintingPlace(PaintingPlaceEvent event) {
        Block placedOn = event.getBlock();
        Player player = event.getPlayer();
        World world = placedOn.getWorld();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(world);
        if (wcfg.getBlacklist() != null && !wcfg.getBlacklist().check(new ItemUseBlacklistEvent(this.plugin.wrapPlayer(player), BukkitUtil.toVector(player.getLocation()), 321), false, false)) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.useRegions && !this.plugin.getGlobalRegionManager().canBuild(player, placedOn.getLocation())) {
            player.sendMessage(ChatColor.DARK_RED + "You don't have permission for this area.");
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityRegainHealth(EntityRegainHealthEvent event) {
        Entity ent = event.getEntity();
        World world = ent.getWorld();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(world);
        if (wcfg.disableHealthRegain) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEndermanPickup(EntityChangeBlockEvent event) {
        LivingEntity ent = event.getEntity();
        Block block = event.getBlock();
        Location location = block.getLocation();
        if (ent instanceof Enderman) {
            if (event.getTo() == Material.AIR) {
                ConfigurationManager cfg = this.plugin.getGlobalStateManager();
                WorldConfiguration wcfg = cfg.get(ent.getWorld());
                if (wcfg.disableEndermanGriefing) {
                    event.setCancelled(true);
                    return;
                }
                if (wcfg.useRegions && !this.plugin.getGlobalRegionManager().allows(DefaultFlag.ENDER_BUILD, location)) {
                    event.setCancelled(true);
                    return;
                }
            } else {
                ConfigurationManager cfg = this.plugin.getGlobalStateManager();
                WorldConfiguration wcfg = cfg.get(ent.getWorld());
                if (wcfg.disableEndermanGriefing) {
                    event.setCancelled(true);
                    return;
                }
                if (wcfg.useRegions && !this.plugin.getGlobalRegionManager().allows(DefaultFlag.ENDER_BUILD, location)) {
                    event.setCancelled(true);
                    return;
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onFoodLevelChange(FoodLevelChangeEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            if (event.getFoodLevel() < player.getFoodLevel() && this.isInvincible(player)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPotionSplash(PotionSplashEvent event) {
        GlobalRegionManager global = this.plugin.getGlobalRegionManager();
        int blockedEntities = 0;
        for (LivingEntity e : event.getAffectedEntities()) {
            if (global.allows(DefaultFlag.POTION_SPLASH, e.getLocation(), e instanceof Player ? this.plugin.wrapPlayer((Player)e) : null)) continue;
            event.setIntensity(e, 0.0);
            ++blockedEntities;
        }
        if (blockedEntities == event.getAffectedEntities().size()) {
            event.setCancelled(true);
        }
    }

    private boolean isInvincible(Player player) {
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(player.getWorld());
        boolean god = cfg.hasGodMode(player);
        if (wcfg.useRegions) {
            Boolean flag = RegionQueryUtil.isAllowedInvinciblity(this.plugin, player);
            boolean allowed = flag == null || flag != false;
            boolean invincible = RegionQueryUtil.isInvincible(this.plugin, player);
            if (allowed) {
                return god || invincible;
            }
            return god && this.plugin.hasPermission((CommandSender)player, "worldguard.god.override-regions") || invincible;
        }
        return god;
    }

    public void tryCancelPVPEvent(Player attackingPlayer, Player defendingPlayer, EntityDamageByEntityEvent event) {
        DisallowedPVPEvent disallowedPVPEvent = new DisallowedPVPEvent(attackingPlayer, defendingPlayer, event);
        this.plugin.getServer().getPluginManager().callEvent((Event)disallowedPVPEvent);
        if (!disallowedPVPEvent.isCancelled()) {
            attackingPlayer.sendMessage(ChatColor.DARK_RED + "You are in a no-PvP area.");
            event.setCancelled(true);
        }
    }
}

