package immibis.chunkloader;

import forge.DimensionManager;
import forge.IChunkLoadHandler;
import forge.IGuiHandler;
import forge.MinecraftForge;
import immibis.core.CompatibleBaseMod;
import immibis.core.Config;
import immibis.core.CoreProxy;
import immibis.core.IBlockIDCallback;
import immibis.core.ModInfoReader;
import immibis.core.NonSharedProxy;
import immibis.core.net.IPacket;
import immibis.core.net.IPacketMap;
import immibis.core.net.OneTwoFiveNetworking;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.Block;
import net.minecraft.server.Chunk;
import net.minecraft.server.ChunkCoordIntPair;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.ModLoader;
import net.minecraft.server.TileEntity;
import net.minecraft.server.World;

public class Main extends CompatibleBaseMod implements IChunkLoadHandler, IGuiHandler
{
    public static final int GUI_CHUNKLOADER = 0;
    public static final byte S2C_GUI_UPDATE = 0;
    public static final byte C2S_DATA_REQUEST = 1;
    public static final byte S2C_DATA_RESPONSE = 2;
    public static final String CHANNEL = "immibis.chunkldr";
    public static final int MAX_RADIUS = 4;
    public Map worlds = new HashMap();
    public int maxQuota = 18;
    public boolean showOtherPlayersLoaders = false;
    public static boolean DEBUG = false;
    public static Main instance;
    public BlockChunkLoader block;

    public boolean isWorldCurrent(World var1)
    {
        return DimensionManager.getWorld(var1.worldProvider.dimension) == var1;
    }

    public String getPriorities()
    {
        return "after:mod_ImmibisCore;";
    }

    public WorldInfo getWorld(World var1)
    {
        WorldInfo var2 = (WorldInfo)this.worlds.get(var1);

        if (var2 != null)
        {
            return var2;
        }
        else
        {
            var2 = WorldInfo.get(var1);
            this.worlds.put(var1, var2);
            Logging.onLoadWorld(var2);
            return var2;
        }
    }

    public Main()
    {
        instance = this;
    }

    public boolean clientSideRequired()
    {
        return true;
    }

    public boolean serverSideRequired()
    {
        return false;
    }

    public String getVersion()
    {
        return ModInfoReader.getModInfoField("/immibis/chunkloader/mod_ImmiChunkLoaders.info.txt", "version");
    }

    public void load()
    {
        CoreProxy.RegisterBlockID("chunkloader", new IBlockIDCallback()
        {
            public void registerBlock(int var1)
            {
                Main.this.block = new BlockChunkLoader(var1);
                ModLoader.registerBlock(Main.this.block, ItemChunkLoader.class);
                ModLoader.addRecipe(new ItemStack(Main.this.block, 1, 0), new Object[] {" G ", "GIG", " G ", 'G', Item.GOLD_INGOT, 'I', Block.IRON_BLOCK});
            }
        });
        ModLoader.registerTileEntity(TileChunkLoader.class, "immibis.chunkloader.TileChunkLoader");
        ModLoader.setInGameHook(this, true, false);
        MinecraftForge.registerChunkLoadHandler(this);
        MinecraftForge.setGuiHandler(this, this);
        OneTwoFiveNetworking.initReceive(new Main.PacketMap(null), "immibis.chunkldr");

        if (NonSharedProxy.SERVER)
        {
            this.maxQuota = Config.getInt("chunkloader.maxChunksPerPlayer", 3);
            this.showOtherPlayersLoaders = !Config.getBoolean("chunkloader.hideOtherPlayersLoadersInF9", true);
        }

        String var1 = Config.getString("chunkloader.logFileName", NonSharedProxy.CLIENT ? "" : "dimensional-anchors.log", "logging", "Name of a file to log creation, deletion and editing of chunk loaders to. Blank for none.").trim();
        String var2 = Config.getString("chunkloader.listFileName", "", "logging", "Name of a file to keep updated with a list of all active chunk loaders. Blank for none.").trim();

        if (!var1.isEmpty())
        {
            Logging.openLog(var1);
        }

        if (!var2.isEmpty())
        {
            Logging.setList(var2);
        }
    }

    public boolean onTickInGame(MinecraftServer var1)
    {
        HashSet var2 = new HashSet();
        Iterator var3 = this.worlds.entrySet().iterator();

        while (var3.hasNext())
        {
            Entry var4 = (Entry)var3.next();

            if (!this.isWorldCurrent((World)var4.getKey()))
            {
                var2.add(var4.getKey());
                Logging.onUnloadWorld((WorldInfo)var4.getValue());
            }
            else
            {
                ((WorldInfo)var4.getValue()).tick();
            }
        }

        var3 = var2.iterator();

        while (var3.hasNext())
        {
            World var5 = (World)var3.next();
            this.worlds.remove(var5);
        }

        Logging.flushLog();
        return true;
    }

    public Object getGuiElement(int var1, EntityHuman var2, World var3, int var4, int var5, int var6)
    {
        TileEntity var7 = var3.getTileEntity(var4, var5, var6);
        return var1 == 0 ? new ContainerChunkLoader(var2, (TileChunkLoader)var7) : null;
    }

    public boolean canUpdateEntity(Entity var1)
    {
        return this.getWorld(var1.world).isChunkForceLoaded(new ChunkCoordIntPair(var1.ca, var1.cc));
    }

    public boolean canUnloadChunk(Chunk var1)
    {
        return !this.getWorld(var1.world).isChunkForceLoaded(var1.k());
    }

    public void addActiveChunks(World var1, Set var2)
    {
        var2.addAll(this.getWorld(var1).getLoadedChunks());
    }

    public int getCurQuota(String var1)
    {
        int var2 = 0;
        int var5;

        for (Iterator var3 = this.worlds.entrySet().iterator(); var3.hasNext(); var2 += var5)
        {
            Entry var4 = (Entry)var3.next();
            var5 = ((WorldInfo)var4.getValue()).getCurQuota(var1);
        }

        return var2;
    }

    public int getMaxQuota(String var1)
    {
        return NonSharedProxy.isOp(var1) ? -2 : this.maxQuota;
    }

    public boolean canAddQuota(String var1, int var2)
    {
        if (var2 <= 0)
        {
            return true;
        }
        else
        {
            int var3 = this.getMaxQuota(var1);
            return var3 == -2 ? true : this.getCurQuota(var1) + var2 <= var3;
        }
    }

    public static Iterable allWorlds()
    {
        return instance.worlds.values();
    }

    private static class PacketMap implements IPacketMap
    {
        private PacketMap() {}

        public IPacket createPacket(byte var1)
        {
            return (IPacket)(var1 == 0 && NonSharedProxy.CLIENT ? new PacketGUIUpdate("", 0, 0, 0, false, false) : (var1 == 1 && NonSharedProxy.SERVER ? new PacketShowChunksRequest() : (var1 == 2 && NonSharedProxy.CLIENT ? new PacketShowChunksResponse() : null)));
        }

        PacketMap(Object var1)
        {
            this();
        }
    }
}
