package immibis.chunkloader;

import immibis.core.TileCombined;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.NBTTagCompound;

public class TileChunkLoader extends TileCombined
{
    public WorldInfo worldInfo;
    public String owner;
    public int radius = 0;
    public boolean isServerOwned = false;

    public boolean canUpdate()
    {
        return false;
    }

    /**
     * Writes a tile entity to NBT.
     */
    public void b(NBTTagCompound var1)
    {
        super.b(var1);
        var1.setString("owner", this.owner == null ? "" : this.owner);
        var1.setInt("radius", this.radius);
    }

    /**
     * Reads a tile entity from NBT.
     */
    public void a(NBTTagCompound var1)
    {
        super.a(var1);
        this.owner = var1.getString("owner");

        if (this.owner != null && this.owner.equals(""))
        {
            this.owner = null;
        }

        this.radius = var1.getInt("radius");
    }

    public boolean onBlockActivated(EntityHuman var1)
    {
        var1.openGui(Main.instance, 0, this.world, this.x, this.y, this.z);
        return true;
    }

    /**
     * validates a tile entity
     */
    public void m()
    {
        super.m();
        this.worldInfo = Main.instance.getWorld(this.world);
        this.worldInfo.addLoader(this);

        if (this.owner != null)
        {
            Logging.onValidated(this.getLoaderInfo(), "<unknown>");
        }
    }

    /**
     * invalidates a tile entity
     */
    public void j()
    {
        super.j();
        this.worldInfo.delayRemoveLoader(this);

        if (this.owner != null)
        {
            Logging.onInvalidated(this.getLoaderInfo(), "<unknown>");
        }
    }

    private void loaderChanged()
    {
        this.worldInfo.readdLoader(this);
    }

    public void loaderChanged(String var1)
    {
        this.loaderChanged(var1, false);
    }

    public void loaderChanged(String var1, boolean var2)
    {
        this.worldInfo.readdLoader(this);

        if (var2)
        {
            Logging.onAdded(this.getLoaderInfo(), var1);
        }
        else
        {
            Logging.onChanged(this.getLoaderInfo(), var1);
        }
    }

    public void limitRadius()
    {
        if (this.owner == null)
        {
            this.radius = -1;
        }
        else
        {
            int var1 = Main.instance.getMaxQuota(this.owner);

            if (var1 != -2)
            {
                while (this.radius >= 0 && Main.instance.getCurQuota(this.owner) + (2 * this.radius + 1) * (2 * this.radius + 1) > var1)
                {
                    --this.radius;
                    this.loaderChanged("<enforcing quota limit for " + this.owner + ">");
                }
            }
        }
    }

    public WorldInfo.LoaderInfo getLoaderInfo()
    {
        WorldInfo.LoaderInfo var1 = new WorldInfo.LoaderInfo(new WorldInfo.XYZ(this), this.worldInfo, this.owner, this.radius);
        var1.isServerOwned = this.isServerOwned;
        return var1;
    }
}
